/*
 * Decompiled with CFR 0.152.
 */
package dev.gabereal.eplayers.mixin;

import dev.gabereal.eplayers.EliminatePlayers;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_355;
import net.minecraft.class_640;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_355.class})
public class PlayerListHudMixin {
    @Inject(method={"collectPlayerEntries"}, at={@At(value="RETURN")}, cancellable=true)
    private void filterBannedPlayers(CallbackInfoReturnable<List<class_640>> cir) {
        List originalList = (List)cir.getReturnValue();
        if (originalList == null) {
            return;
        }
        List filteredList = originalList.stream().filter(entry -> {
            if (entry.method_2966() == null) {
                return true;
            }
            UUID playerUuid = entry.method_2966().getId();
            boolean isBanned = EliminatePlayers.bannedUuids.contains(playerUuid);
            if (isBanned) {
                EliminatePlayers.LOGGER.debug("Hiding banned player from tab list: {} ({})", (Object)entry.method_2966().getName(), (Object)playerUuid);
            }
            return !isBanned;
        }).collect(Collectors.toList());
        cir.setReturnValue(filteredList);
    }
}

