/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.object;

import com.loohp.imageframe.ImageFrameClient;
import com.loohp.imageframe.configuration.Configuration;
import com.loohp.imageframe.object.ImageMapData;
import com.loohp.imageframe.object.MapTooltipComponent;
import net.minecraft.class_10090;
import net.minecraft.class_10799;
import net.minecraft.class_22;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_330;
import net.minecraft.class_332;
import net.minecraft.class_638;
import net.minecraft.class_9209;
import org.joml.Matrix3x2fStack;

public class ImageMapTooltipComponent
implements MapTooltipComponent {
    private final float BG_INSET = 1.0f;
    private final float PAD_PX = 2.0f;
    private final class_2960 background = class_2960.method_60654((String)"textures/map/map_background.png");
    private final class_10090 mapRenderState = new class_10090();
    private final int index;

    public ImageMapTooltipComponent(int index) {
        this.index = index;
    }

    public int method_32661(class_327 textRenderer) {
        return ImageFrameClient.MOD.getOrRequestImageMapData(this.index) == null ? 0 : 66;
    }

    public int method_32664(class_327 textRenderer) {
        ImageMapData data = ImageFrameClient.MOD.getOrRequestImageMapData(this.index);
        if (data == null) {
            return 0;
        }
        return this.getWidth(data);
    }

    public int getWidth(ImageMapData data) {
        int cols = data.width();
        int rows = data.height();
        float availableH = 62.0f;
        float usableH = Math.max(0.0f, availableH - 4.0f);
        int tileSizePxInt = Math.max(1, (int)Math.floor(usableH / (float)rows));
        float totalWidth = (float)(cols * tileSizePxInt) + 4.0f + 2.0f;
        return (int)Math.ceil(totalWidth);
    }

    public void method_32666(class_327 textRenderer, int x, int y, int width, int height, class_332 context) {
        if (!Configuration.previewMapsInTooltip) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (world == null) {
            return;
        }
        ImageMapData imageMapData = ImageFrameClient.MOD.getOrRequestImageMapData(this.index);
        if (imageMapData == null) {
            return;
        }
        int gridCols = imageMapData.width();
        int gridRows = imageMapData.height();
        float availableH = 62.0f;
        float usableH = Math.max(0.0f, availableH - 4.0f);
        int tileSizePxInt = Math.max(1, (int)Math.floor(usableH / (float)gridRows));
        int mapWidth = this.getWidth(imageMapData);
        context.method_25290(class_10799.field_56883, this.background, x, y, 0.0f, 0.0f, mapWidth, 64, mapWidth, 64);
        float gridW = (float)(gridCols * tileSizePxInt) + 4.0f;
        float gridH = (float)(gridRows * tileSizePxInt) + 4.0f;
        float originX = x + Math.round(((float)mapWidth - gridW) * 0.5f);
        float originY = y + Math.round((64.0f - gridH) * 0.5f);
        float overlap = 0.25f;
        float tileScale = ((float)tileSizePxInt + overlap) / 128.0f;
        class_330 mapRenderer = client.method_61965();
        Matrix3x2fStack matrix = context.method_51448();
        for (int i = 0; i < imageMapData.mapIds().size(); ++i) {
            class_9209 id = new class_9209(imageMapData.mapIds().getInt(i));
            int col = i % gridCols;
            int row = i / gridCols;
            class_22 data = world.method_17891(id);
            if (data == null) continue;
            mapRenderer.method_62230(id, data, this.mapRenderState);
            float drawX = originX + 2.0f + (float)(col * tileSizePxInt);
            float drawY = originY + 2.0f + (float)(row * tileSizePxInt);
            matrix.pushMatrix();
            matrix.translate(drawX, drawY);
            matrix.translate(-overlap * 0.5f, -overlap * 0.5f);
            matrix.scale(tileScale, tileScale);
            context.method_70857(this.mapRenderState);
            matrix.popMatrix();
        }
    }
}

