/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.object;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.ByteArrayOutputStream;
import java.util.concurrent.atomic.AtomicInteger;

public class MultipartHdMapInfo {
    private final byte[] EMPTY_ARRAY = new byte[0];
    private final Int2ObjectMap<byte[]> buffer = new Int2ObjectArrayMap();
    private final AtomicInteger lastIndex = new AtomicInteger(0);

    public void put(int index, byte[] data) {
        this.buffer.put(index, (Object)data);
    }

    public void setLastIndex(int index) {
        this.lastIndex.set(index);
    }

    public boolean isCompleted() {
        int max = this.lastIndex.get();
        if (max <= 0) {
            return false;
        }
        for (int i = 0; i <= max; ++i) {
            if (this.buffer.containsKey(i)) continue;
            return false;
        }
        return true;
    }

    public byte[] complete() {
        int max = this.lastIndex.get();
        int length = this.buffer.values().stream().mapToInt(b -> ((byte[])b).length).sum();
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        for (int i = 0; i <= max; ++i) {
            out.writeBytes((byte[])this.buffer.getOrDefault(i, (Object)this.EMPTY_ARRAY));
        }
        return out.toByteArray();
    }
}

