/*
 * Decompiled with CFR 0.152.
 */
package net.starflightraven.rubylands;

import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddPackFindersEvent;

@EventBusSubscriber(modid="rd", bus=EventBusSubscriber.Bus.MOD)
public final class BuiltinResourcePacksRegistrar {
    private static final PackEntry[] PACKS = new PackEntry[]{new PackEntry("programmer_art", "Omprogrammert", false)};

    @SubscribeEvent
    public static void onAddPackFinders(AddPackFindersEvent event) {
        System.out.println("[ResourcePacks] AddPackFindersEvent fired for type: " + String.valueOf(event.getPackType()));
        if (event.getPackType() != PackType.CLIENT_RESOURCES) {
            System.out.println("[ResourcePacks] Not client resources, skipping");
            return;
        }
        Optional containerOpt = ModList.get().getModContainerById("rd");
        if (containerOpt.isEmpty()) {
            System.out.println("[ResourcePacks] Could not find mod container for rd");
            return;
        }
        Path modFileRoot = ((ModContainer)containerOpt.get()).getModInfo().getOwningFile().getFile().getFilePath();
        System.out.println("[ResourcePacks] Mod file root: " + String.valueOf(modFileRoot));
        String pathStr = modFileRoot.toString();
        if (pathStr.contains("build" + System.getProperty("file.separator") + "classes")) {
            Path srcResources;
            Path projectRoot;
            for (projectRoot = modFileRoot; projectRoot != null && !Files.exists(projectRoot.resolve("src"), new LinkOption[0]); projectRoot = projectRoot.getParent()) {
            }
            if (projectRoot != null && Files.exists(srcResources = projectRoot.resolve("src").resolve("main").resolve("resources"), new LinkOption[0])) {
                modFileRoot = srcResources;
                System.out.println("[ResourcePacks] Development mode - using: " + String.valueOf(modFileRoot));
            }
        } else {
            if (pathStr.endsWith(".jar")) {
                System.out.println("[ResourcePacks] Production mode - JAR file detected");
                try {
                    URI jarUri = URI.create("jar:" + String.valueOf(modFileRoot.toUri()));
                    FileSystem jarFs = FileSystems.newFileSystem(jarUri, Map.of());
                    for (PackEntry entry : PACKS) {
                        final Path jarPackRoot = jarFs.getPath("resourcepacks", entry.folderName());
                        System.out.println("[ResourcePacks] Looking for pack in JAR at: " + String.valueOf(jarPackRoot));
                        if (!Files.exists(jarPackRoot, new LinkOption[0])) {
                            System.out.println("[ResourcePacks] Pack directory does not exist in JAR: " + String.valueOf(jarPackRoot));
                            continue;
                        }
                        String id = "rd:" + entry.folderName();
                        MutableComponent title = Component.literal((String)entry.displayName());
                        System.out.println("[ResourcePacks] Registering JAR pack: " + id + " (" + entry.displayName() + ")");
                        try {
                            final PackLocationInfo location = new PackLocationInfo(id, (Component)title, PackSource.DEFAULT, Optional.empty());
                            PackSelectionConfig config = new PackSelectionConfig(entry.alwaysEnabled(), Pack.Position.TOP, false);
                            Pack.ResourcesSupplier supplier = new Pack.ResourcesSupplier(){

                                public PackResources openPrimary(PackLocationInfo packLocationInfo) {
                                    return new PathPackResources(location, jarPackRoot);
                                }

                                public PackResources openFull(PackLocationInfo packLocationInfo, Pack.Metadata metadata) {
                                    return new PathPackResources(location, jarPackRoot);
                                }
                            };
                            Pack pack = Pack.readMetaAndCreate((PackLocationInfo)location, (Pack.ResourcesSupplier)supplier, (PackType)event.getPackType(), (PackSelectionConfig)config);
                            if (pack != null) {
                                event.addRepositorySource(consumer -> {
                                    consumer.accept(pack);
                                    System.out.println("[ResourcePacks] JAR pack accepted by repository: " + id);
                                });
                                System.out.println("[ResourcePacks] Successfully registered JAR pack: " + id);
                                continue;
                            }
                            System.out.println("[ResourcePacks] Failed to create JAR pack: " + id);
                        }
                        catch (Exception e) {
                            System.out.println("[ResourcePacks] Exception while registering JAR pack " + id + ": " + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println("[ResourcePacks] Failed to open JAR filesystem: " + e.getMessage());
                    e.printStackTrace();
                }
                return;
            }
            System.out.println("[ResourcePacks] Production mode - using: " + String.valueOf(modFileRoot));
        }
        for (PackEntry entry : PACKS) {
            final Path packRoot = modFileRoot.resolve("resourcepacks").resolve(entry.folderName());
            System.out.println("[ResourcePacks] Looking for pack at: " + String.valueOf(packRoot));
            if (!Files.exists(packRoot, new LinkOption[0])) {
                System.out.println("[ResourcePacks] Pack directory does not exist: " + String.valueOf(packRoot));
                continue;
            }
            String id = "rd:" + entry.folderName();
            MutableComponent title = Component.literal((String)entry.displayName());
            System.out.println("[ResourcePacks] Registering pack: " + id + " (" + entry.displayName() + ")");
            try {
                final PackLocationInfo location = new PackLocationInfo(id, (Component)title, PackSource.DEFAULT, Optional.empty());
                PackSelectionConfig config = new PackSelectionConfig(entry.alwaysEnabled(), Pack.Position.TOP, false);
                Pack.ResourcesSupplier supplier = new Pack.ResourcesSupplier(){

                    public PackResources openPrimary(PackLocationInfo packLocationInfo) {
                        return new PathPackResources(location, packRoot);
                    }

                    public PackResources openFull(PackLocationInfo packLocationInfo, Pack.Metadata metadata) {
                        return new PathPackResources(location, packRoot);
                    }
                };
                Pack pack = Pack.readMetaAndCreate((PackLocationInfo)location, (Pack.ResourcesSupplier)supplier, (PackType)event.getPackType(), (PackSelectionConfig)config);
                if (pack != null) {
                    event.addRepositorySource(consumer -> {
                        consumer.accept(pack);
                        System.out.println("[ResourcePacks] Pack accepted by repository: " + id);
                    });
                    System.out.println("[ResourcePacks] Successfully registered pack: " + id);
                    continue;
                }
                System.out.println("[ResourcePacks] Failed to create pack: " + id);
            }
            catch (Exception e) {
                System.out.println("[ResourcePacks] Exception while registering pack " + id + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private record PackEntry(String folderName, String displayName, boolean alwaysEnabled) {
    }
}

