/*
 * Decompiled with CFR 0.152.
 */
package net.starflightraven.rubylands.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.starflightraven.rubylands.entity.EssenceBulletEntity;
import net.starflightraven.rubylands.entity.ObserverEntity;
import net.starflightraven.rubylands.entity.RecruiterEntity;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class RdModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"rd");
    public static final DeferredHolder<EntityType<?>, EntityType<ObserverEntity>> OBSERVER = RdModEntities.register("observer", EntityType.Builder.of(ObserverEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<RecruiterEntity>> RECRUITER = RdModEntities.register("recruiter", EntityType.Builder.of(RecruiterEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<EssenceBulletEntity>> ESSENCE_BULLET = RdModEntities.register("essence_bullet", EntityType.Builder.of(EssenceBulletEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        ObserverEntity.init(event);
        RecruiterEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)OBSERVER.get(), ObserverEntity.createAttributes().build());
        event.put((EntityType)RECRUITER.get(), RecruiterEntity.createAttributes().build());
    }
}

