/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.aces_spell_utils.items.example;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.entity.spells.comet.Comet;
import net.acetheeldritchking.aces_spell_utils.items.curios.SheathCurioItem;
import net.acetheeldritchking.aces_spell_utils.registries.ASAttributeRegistry;
import net.acetheeldritchking.aces_spell_utils.registries.ExampleItemRegistry;
import net.acetheeldritchking.aces_spell_utils.utils.ASRarities;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class ExampleSheathCurioItem
extends SheathCurioItem {
    public static final int COOLDOWN = 100;

    public ExampleSheathCurioItem() {
        super(new Item.Properties().stacksTo(1).rarity((Rarity)ASRarities.COSMIC_RARITY_PROXY.getValue()).fireResistant(), null);
    }

    protected int getCooldownTicks() {
        return 100;
    }

    @SubscribeEvent
    public static void handleAbility(LivingIncomingDamageEvent event) {
        ServerPlayer player;
        ExampleSheathCurioItem sheath = (ExampleSheathCurioItem)ExampleItemRegistry.EXAMPLE_SHEATH.get();
        Entity attacker = event.getSource().getEntity();
        if (attacker instanceof ServerPlayer && sheath.isEquippedBy((LivingEntity)(player = (ServerPlayer)attacker)) && sheath.tryProcCooldown((Player)player)) {
            LivingEntity victim = event.getEntity();
            Comet comet = new Comet(player.level(), (LivingEntity)player);
            comet.setDamage(5.0f);
            comet.setPos(victim.getX(), victim.getY() + 7.0, victim.getZ());
            Vec3 trajectory = new Vec3((double)0.05f, (double)-0.85f, 0.0).normalize();
            comet.shoot(trajectory, 0.045f);
            comet.setExplosionRadius(4.5f);
            player.level().addFreshEntity((Entity)comet);
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        LinkedHashMultimap attr = LinkedHashMultimap.create();
        attr.put((Object)AttributeRegistry.ENDER_SPELL_POWER, (Object)new AttributeModifier(id, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        attr.put(ASAttributeRegistry.EVASIVE, (Object)new AttributeModifier(id, 50.0, AttributeModifier.Operation.ADD_VALUE));
        attr.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(id, 0.05, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return attr;
    }
}

