/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.client.animators;

import com.nukateam.cgs.client.animators.EngineAnimator;
import com.nukateam.cgs.common.faundation.registry.items.CgsAttachments;
import com.nukateam.cgs.common.ntgl.CgsAttachmentTypes;
import com.nukateam.ntgl.client.animators.WeaponAnimator;
import com.nukateam.ntgl.client.render.renderers.weapon.DynamicWeaponRenderer;
import com.nukateam.ntgl.client.util.handler.ClientReloadHandler;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.config.weapon.WeaponConfig;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.util.util.Cycler;
import com.nukateam.ntgl.common.util.util.FuelUtils;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import com.nukateam.ntgl.common.util.util.WeaponStateHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class GatlingAnimator
extends EngineAnimator {
    public static final String HANDLE = "handle";
    public static final String VOID = "void";
    public static final String RELOAD_DRUM = "reload_drum";
    protected Cycler handleCycler = new Cycler(1, this.getBarrelAmount());
    private boolean hasDrum;
    protected final AnimationController<WeaponAnimator> HANDLE_CONTROLLER = this.createController("handle_controller", this.animateHandle());
    protected final AnimationController<WeaponAnimator> GATLING_TRIGGER = this.createController("gatling_trigger", event -> PlayState.CONTINUE).triggerableAnim("handle", RawAnimation.begin().then("handle", Animation.LoopType.PLAY_ONCE)).triggerableAnim("void", RawAnimation.begin().then("void", Animation.LoopType.PLAY_ONCE));

    public GatlingAnimator(ItemDisplayContext transformType, DynamicWeaponRenderer<WeaponAnimator> renderer) {
        super(transformType, renderer);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        super.registerControllers(controllerRegistrar);
        controllerRegistrar.add(new AnimationController[]{this.HANDLE_CONTROLLER});
        controllerRegistrar.add(new AnimationController[]{this.GATLING_TRIGGER});
    }

    protected int getBarrelAmount() {
        return 4;
    }

    @Override
    protected void tickStart() {
        super.tickStart();
        ItemStack magazine = WeaponStateHelper.getAttachmentItem((AttachmentType)AttachmentType.MAGAZINE, (ItemStack)this.getStack());
        this.hasDrum = magazine.m_150930_((Item)CgsAttachments.GATLING_DRUM.get());
        float cooldown = this.shootingHandler.getCooldown(this.getEntity(), this.arm);
        if (cooldown == (float)this.rate) {
            this.handleCycler.cycle();
        }
    }

    protected RawAnimation getReloadingAnimation(AnimationState<WeaponAnimator> event) {
        this.HANDLE_CONTROLLER.setAnimation(RawAnimation.begin().then(VOID, Animation.LoopType.PLAY_ONCE));
        return super.getReloadingAnimation(event);
    }

    protected RawAnimation getDefaultReloadAnimation(AnimationState<WeaponAnimator> event) {
        if (this.hasDrum) {
            WeaponData data = new WeaponData(this.getStack(), this.getEntity());
            int time = WeaponModifierHelper.getReloadTime((WeaponData)data);
            this.animationHelper.syncAnimation(event, RELOAD_DRUM, time);
            return RawAnimation.begin().then(RELOAD_DRUM, Animation.LoopType.LOOP);
        }
        return super.getDefaultReloadAnimation(event);
    }

    protected AnimationController.AnimationStateHandler<WeaponAnimator> animateHandle() {
        return event -> {
            WeaponConfig gun = ((WeaponItem)this.getStack().m_41720_()).getConfig();
            RawAnimation animation = RawAnimation.begin();
            boolean hasEngine = WeaponStateHelper.hasAttachmentEquipped((ItemStack)this.getStack(), (AttachmentType)CgsAttachmentTypes.ENGINE);
            boolean hasFuel = FuelUtils.hasFuel((WeaponData)this.getGunData());
            if (hasEngine && hasFuel || this.hasAnimationPlaying((AnimationController<WeaponAnimator>)this.MAIN_CONTROLLER, "reload")) {
                return PlayState.STOP;
            }
            ClientReloadHandler reloadHandler = ClientReloadHandler.get();
            if (!reloadHandler.isReloading(this.getEntity(), this.getArm())) {
                PlayState handleAnim = this.getCycledAnimation(event, HANDLE, this.handleCycler);
                return handleAnim;
            }
            animation = RawAnimation.begin().then(VOID, Animation.LoopType.PLAY_ONCE);
            return event.setAndContinue(animation);
        };
    }

    private boolean hasAnimationPlaying(AnimationController<WeaponAnimator> controller, String name) {
        AnimationProcessor.QueuedAnimation animation = controller.getCurrentAnimation();
        return animation != null && animation.animation().name().equals(name);
    }
}

