/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.client.animators;

import com.nukateam.cgs.common.faundation.registry.items.CgsAttachments;
import com.nukateam.cgs.common.ntgl.CgsAttachmentTypes;
import com.nukateam.ntgl.client.animators.WeaponAnimator;
import com.nukateam.ntgl.client.render.renderers.weapon.DynamicWeaponRenderer;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import com.nukateam.ntgl.common.util.util.WeaponStateHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;

public class RevolverAnimator
extends WeaponAnimator {
    public static final String BELT = "belt";
    private boolean hasBelt;
    private boolean isAuto;
    private boolean oneHanded = false;
    protected final AnimationController<WeaponAnimator> BELT_CONTROLLER = this.createController("belt_controller", this.animateBelt()).triggerableAnim("belt", RawAnimation.begin().then("belt", Animation.LoopType.PLAY_ONCE));

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        super.registerControllers(controllerRegistrar);
    }

    public void tick(TickEvent event) {
        super.tick(event);
        if (event.phase == TickEvent.Phase.START && this.isGun()) {
            ItemStack chamberAttachment = WeaponStateHelper.getAttachmentItem((AttachmentType)CgsAttachmentTypes.CHAMBER, (ItemStack)this.getStack());
            ItemStack frame = WeaponStateHelper.getAttachmentItem((AttachmentType)CgsAttachmentTypes.FRAME, (ItemStack)this.getStack());
            ItemStack barrel = WeaponStateHelper.getAttachmentItem((AttachmentType)AttachmentType.BARREL, (ItemStack)this.getStack());
            this.hasBelt = chamberAttachment.m_150930_((Item)CgsAttachments.REVOLVER_BELT.get());
            this.isAuto = frame.m_150930_((Item)CgsAttachments.REVOLVER_AUTO.get());
            this.oneHanded = barrel.m_41619_();
            this.oneHanded = WeaponModifierHelper.isOneHanded((WeaponData)this.getGunData());
        }
    }

    private AnimationController.AnimationStateHandler<WeaponAnimator> animateBelt() {
        return event -> {
            if (this.hasBelt && this.shootingHandler.isOnCooldown(this.getEntity(), this.getArm())) {
                RawAnimation animation = RawAnimation.begin().then(BELT, Animation.LoopType.PLAY_ONCE).then("void", Animation.LoopType.PLAY_ONCE);
                return event.setAndContinue(animation);
            }
            return event.setAndContinue(RawAnimation.begin().then("void", Animation.LoopType.PLAY_ONCE));
        };
    }

    public RevolverAnimator(ItemDisplayContext transformType, DynamicWeaponRenderer<WeaponAnimator> renderer) {
        super(transformType, renderer);
    }

    protected String getGunAnim(String name) {
        if (this.oneHanded && this.animationHelper.hasAnimation((String)name + "_one_hand")) {
            name = (String)name + "_one_hand";
        }
        return name;
    }

    protected RawAnimation getHoldAnimation(AnimationState<WeaponAnimator> event) {
        if (this.isAuto) {
            return this.playGunAnim("hold_auto", Animation.LoopType.LOOP);
        }
        return super.getHoldAnimation(event);
    }

    protected RawAnimation getShootingAnimation(AnimationState<WeaponAnimator> event) {
        if (this.isAuto) {
            RawAnimation animation = this.playGunAnim("shot_auto", Animation.LoopType.LOOP);
            this.animationHelper.syncAnimation(event, "shot_auto", this.rate);
            return animation;
        }
        return super.getShootingAnimation(event);
    }

    protected RawAnimation getReloadingAnimation(AnimationState<WeaponAnimator> event) {
        if (this.hasBelt) {
            RawAnimation animation = RawAnimation.begin();
            animation.then("reload_belt", Animation.LoopType.LOOP);
            WeaponData data = new WeaponData(this.getStack(), this.getEntity());
            this.animationHelper.syncAnimation(event, "reload_belt", WeaponModifierHelper.getReloadTime((WeaponData)data));
            return animation;
        }
        return super.getReloadingAnimation(event);
    }

    private boolean isGun() {
        return this.getStack().m_41720_() instanceof WeaponItem;
    }
}

