/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.handlers;

import com.nukateam.cgs.common.faundation.item.attachments.HammerHeadItem;
import com.nukateam.cgs.common.faundation.item.guns.HammerItem;
import com.nukateam.cgs.common.faundation.registry.items.CgsWeapons;
import com.nukateam.cgs.common.ntgl.CgsAttachmentTypes;
import com.nukateam.cgs.common.utils.BreakHandler;
import com.nukateam.ntgl.Config;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.data.holders.WeaponMode;
import com.nukateam.ntgl.common.event.MeleeAttackEvent;
import com.nukateam.ntgl.common.util.util.StackUtils;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import com.nukateam.ntgl.common.util.util.WeaponStateHelper;
import com.simibubi.create.content.kinetics.saw.TreeCutter;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="cgs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MeleeHandler {
    public static BreakHandler HAMMER_HANDLER = new BreakHandler(MeleeHandler::isToolTierSufficient, MeleeHandler::isMineableHammer, MeleeHandler::isCanDrop);
    public static BreakHandler AXE_HANDLER = new BreakHandler(MeleeHandler::isToolTierSufficient, MeleeHandler::isMineableAxe, MeleeHandler::isCanDropAxe);

    @SubscribeEvent
    public static void onMelee(MeleeAttackEvent.Pre event) {
        LivingEntity livingEntity;
        boolean isHammer;
        WeaponData data = event.getData();
        ItemStack stack = event.getData().weapon;
        boolean isSecondaryMode = data.weaponMode == WeaponMode.SECONDARY;
        boolean bl = isHammer = stack != null && stack.m_41720_() == CgsWeapons.HAMMER.get();
        if (!event.isClient() && isSecondaryMode && isHammer && (livingEntity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            LivingEntity entity = event.getEntity();
            if (!player.m_7500_()) {
                WeaponStateHelper.consumeAmmo((WeaponData)data);
            }
            if (event.getTargets().isEmpty()) {
                MeleeHandler.hitBlock(player, data, entity);
            }
        }
    }

    private static void hitBlock(ServerPlayer player, WeaponData data, LivingEntity entity) {
        assert (data.weapon != null);
        ItemStack head = WeaponStateHelper.getAttachmentItem((AttachmentType)CgsAttachmentTypes.HEAD, (ItemStack)data.weapon);
        Item item = head.m_41720_();
        if (item instanceof HammerHeadItem) {
            HammerHeadItem headItem = (HammerHeadItem)item;
            if (HammerItem.isPowered(data) && !entity.m_21023_(MobEffects.f_19599_)) {
                float reach = WeaponModifierHelper.getMeleeDistance((WeaponData)data);
                boolean isShotPowered = !WeaponStateHelper.getAttachmentItem((AttachmentType)AttachmentType.MAGAZINE, (ItemStack)data.weapon).m_41619_();
                BlockHitResult hitResult = MeleeHandler.getBlockHitResult(player, reach);
                if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
                    return;
                }
                if (headItem.getHeadType() == HammerHeadItem.Type.HAMMER) {
                    if (isShotPowered) {
                        MeleeHandler.breakBlocks3x3(player, headItem.getTier(), HAMMER_HANDLER, head, hitResult);
                    } else {
                        MeleeHandler.breakBlockAt(player, headItem.getTier(), head, hitResult.m_82425_(), HAMMER_HANDLER);
                    }
                } else if (headItem.getHeadType() == HammerHeadItem.Type.AXE) {
                    if (isShotPowered) {
                        MeleeHandler.chopTree(hitResult, player.m_9236_());
                    } else {
                        MeleeHandler.breakBlockAt(player, headItem.getTier(), head, hitResult.m_82425_(), AXE_HANDLER);
                    }
                }
            }
        }
    }

    private static void chopTree(BlockHitResult hitResult, Level level) {
        BlockPos hitPos = hitResult.m_82425_();
        Direction[] planeDirs = MeleeHandler.getPlaneDirections(hitResult.m_82434_());
        BlockPos breakingPos = hitPos.m_5484_(planeDirs[0], -1).m_5484_(planeDirs[1], 0);
        TreeCutter.findTree((BlockGetter)level, (BlockPos)breakingPos, (BlockState)level.m_8055_(breakingPos)).destroyBlocks(level, null, (pos, stack) -> MeleeHandler.dropItemFromCutTree(level, pos, stack));
    }

    private static void dropItemFromCutTree(Level level, BlockPos pos, ItemStack stack) {
        Vec3 dropPos = VecHelper.getCenterOf((Vec3i)pos);
        ItemEntity itemEntity = new ItemEntity(level, dropPos.f_82479_, dropPos.f_82480_, dropPos.f_82481_, stack);
        level.m_7967_((Entity)itemEntity);
    }

    private static void breakBlocks3x3(ServerPlayer player, Tier toolTier, BreakHandler handler, ItemStack stack, BlockHitResult hitResult) {
        Direction[] planeDirs = MeleeHandler.getPlaneDirections(hitResult.m_82434_());
        for (int u = -1; u <= 1; ++u) {
            for (int v = -1; v <= 1; ++v) {
                BlockPos targetPos = hitResult.m_82425_().m_5484_(planeDirs[0], u).m_5484_(planeDirs[1], v);
                MeleeHandler.breakBlockAt(player, toolTier, stack, targetPos, handler);
            }
        }
    }

    @NotNull
    private static BlockHitResult getBlockHitResult(ServerPlayer player, float reach) {
        Vec3 start = player.m_20299_(1.0f);
        Vec3 look = player.m_20252_(1.0f);
        Vec3 end = start.m_82520_(look.f_82479_ * (double)reach, look.f_82480_ * (double)reach, look.f_82481_ * (double)reach);
        return player.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
    }

    private static void breakBlockAt(ServerPlayer player, Tier toolTier, ItemStack stack, BlockPos targetPos, BreakHandler handler) {
        BlockState blockState = player.m_9236_().m_8055_(targetPos);
        boolean canDistroy = blockState.m_60800_((BlockGetter)player.m_9236_(), targetPos) >= 0.0f;
        Boolean canGrief = (Boolean)Config.COMMON.gameplay.griefing.enableBlockRemovalOnExplosions.get();
        if (canGrief.booleanValue() && canDistroy && handler.isToolTierSufficient(blockState, toolTier) && handler.isMineable(blockState)) {
            if (!player.m_7500_()) {
                StackUtils.damageItem((ItemStack)stack, (int)1);
            }
            player.m_9236_().m_46953_(targetPos, handler.isCanDrop(blockState), (Entity)player);
        }
    }

    public static boolean isToolTierSufficient(BlockState blockState, Tier toolTier) {
        if (blockState.m_204336_(BlockTags.f_144284_)) {
            return toolTier.m_6604_() >= Tiers.DIAMOND.m_6604_();
        }
        if (blockState.m_204336_(BlockTags.f_144285_)) {
            return toolTier.m_6604_() >= Tiers.IRON.m_6604_();
        }
        if (blockState.m_204336_(BlockTags.f_144286_)) {
            return toolTier.m_6604_() >= Tiers.STONE.m_6604_();
        }
        return true;
    }

    private static boolean isMineableHammer(BlockState blockState) {
        return true;
    }

    private static boolean isCanDrop(BlockState blockState) {
        return blockState.m_204336_(BlockTags.f_144282_) || blockState.m_204336_(BlockTags.f_144283_);
    }

    private static boolean isMineableAxe(BlockState blockState) {
        return blockState.m_204336_(BlockTags.f_144280_) || blockState.m_204336_(BlockTags.f_144281_);
    }

    private static boolean isCanDropAxe(BlockState blockState) {
        return blockState.m_204336_(BlockTags.f_144280_) || blockState.m_204336_(BlockTags.f_144281_);
    }

    private static Direction[] getPlaneDirections(Direction face) {
        Direction[] directionArray;
        switch (face.m_122434_()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Y: {
                Direction[] directionArray2 = new Direction[2];
                directionArray2[0] = Direction.EAST;
                directionArray = directionArray2;
                directionArray2[1] = Direction.SOUTH;
                break;
            }
            case Z: {
                Direction[] directionArray3 = new Direction[2];
                directionArray3[0] = Direction.UP;
                directionArray = directionArray3;
                directionArray3[1] = Direction.EAST;
                break;
            }
            case X: {
                Direction[] directionArray4 = new Direction[2];
                directionArray4[0] = Direction.UP;
                directionArray = directionArray4;
                directionArray4[1] = Direction.SOUTH;
            }
        }
        return directionArray;
    }
}

