/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.handlers;

import com.nukateam.cgs.common.faundation.item.attachments.HammerHeadItem;
import com.nukateam.cgs.common.faundation.item.guns.HammerItem;
import com.nukateam.cgs.common.faundation.registry.items.CgsWeapons;
import com.nukateam.cgs.common.ntgl.CgsAttachmentTypes;
import com.nukateam.cgs.common.utils.BreakHandler;
import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.event.MeleeAttackEvent;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import com.nukateam.ntgl.common.util.util.StackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="cgs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MeleeHandler {
    public static BreakHandler HAMMER_HANDLER = new BreakHandler(MeleeHandler::isToolTierSufficient, MeleeHandler::isMineable, MeleeHandler::isCanDrop);
    public static BreakHandler AXE_HANDLER = new BreakHandler(MeleeHandler::isToolTierSufficient, MeleeHandler::isMineableAxe, MeleeHandler::isCanDropAxe);

    @SubscribeEvent
    public static void onMelee(MeleeAttackEvent.Pre event) {
        LivingEntity livingEntity;
        if (event.getStack().m_41720_() == CgsWeapons.HAMMER.get() && (livingEntity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            ItemStack stack = event.getStack();
            LivingEntity entity = event.getEntity();
            GunData data = new GunData(stack, entity);
            if (!player.m_7500_()) {
                GunStateHelper.consumeAmmo((GunData)data);
            }
            if (event.getTargets().isEmpty()) {
                MeleeHandler.hitBlock(event, player, data, entity);
            }
        }
    }

    private static void hitBlock(MeleeAttackEvent.Pre event, ServerPlayer player, GunData data, LivingEntity entity) {
        ItemStack head = GunStateHelper.getAttachmentItem((AttachmentType)CgsAttachmentTypes.HEAD, (ItemStack)event.getStack());
        Item item = head.m_41720_();
        if (item instanceof HammerHeadItem) {
            HammerHeadItem headItem = (HammerHeadItem)item;
            if (HammerItem.isPowered(data) && !entity.m_21023_(MobEffects.f_19599_)) {
                boolean isShotPowered;
                float reach = GunModifierHelper.getMeleeDistance((GunData)data);
                boolean bl = isShotPowered = !GunStateHelper.getAttachmentItem((AttachmentType)AttachmentType.MAGAZINE, (ItemStack)event.getStack()).m_41619_();
                if (headItem.getHeadType() == HammerHeadItem.Type.HAMMER) {
                    if (isShotPowered) {
                        MeleeHandler.breakBlocks3x3(player, headItem.getTier(), HAMMER_HANDLER, head, reach);
                    } else {
                        MeleeHandler.breakBlocks2x1(player, headItem.getTier(), HAMMER_HANDLER, head, reach);
                    }
                } else if (headItem.getHeadType() == HammerHeadItem.Type.AXE) {
                    if (isShotPowered) {
                        MeleeHandler.breakBlocks3x3(player, headItem.getTier(), AXE_HANDLER, head, reach);
                    } else {
                        MeleeHandler.breakBlocks2x1(player, headItem.getTier(), AXE_HANDLER, head, reach);
                    }
                }
            }
        }
    }

    private static void breakBlocks2x1(ServerPlayer player, Tier toolTier, BreakHandler handler, ItemStack stack, float reach) {
        BlockHitResult hitResult = MeleeHandler.getBlockHitResult(player, reach);
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockPos centerPos = hitResult.m_82425_();
        Direction[] planeDirs = MeleeHandler.getPlaneDirections(hitResult.m_82434_());
        MeleeHandler.breakBlockAt(player, toolTier, stack, centerPos, planeDirs, handler, 0, 0);
        MeleeHandler.breakBlockAt(player, toolTier, stack, centerPos, planeDirs, handler, -1, 0);
    }

    private static void breakBlocks3x3(ServerPlayer player, Tier toolTier, BreakHandler handler, ItemStack stack, float reach) {
        BlockHitResult hitResult = MeleeHandler.getBlockHitResult(player, reach);
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockPos centerPos = hitResult.m_82425_();
        Direction[] planeDirs = MeleeHandler.getPlaneDirections(hitResult.m_82434_());
        for (int u = -1; u <= 1; ++u) {
            for (int v = -1; v <= 1; ++v) {
                MeleeHandler.breakBlockAt(player, toolTier, stack, centerPos, planeDirs, handler, u, v);
            }
        }
    }

    @NotNull
    private static BlockHitResult getBlockHitResult(ServerPlayer player, float reach) {
        Vec3 start = player.m_20299_(1.0f);
        Vec3 look = player.m_20252_(1.0f);
        Vec3 end = start.m_82520_(look.f_82479_ * (double)reach, look.f_82480_ * (double)reach, look.f_82481_ * (double)reach);
        BlockHitResult hitResult = player.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        return hitResult;
    }

    private static void breakBlockAt(ServerPlayer player, Tier toolTier, ItemStack stack, BlockPos centerPos, Direction[] planeDirs, BreakHandler handler, int u, int v) {
        boolean canDistroy;
        BlockPos targetPos = centerPos.m_5484_(planeDirs[0], u).m_5484_(planeDirs[1], v);
        BlockState blockState = player.m_9236_().m_8055_(targetPos);
        boolean bl = canDistroy = blockState.m_60800_((BlockGetter)player.m_9236_(), targetPos) >= 0.0f;
        if (canDistroy && handler.isToolTierSufficient(blockState, toolTier) && handler.isMineable(blockState)) {
            if (!player.m_7500_()) {
                StackUtils.damageItem((ItemStack)stack, (int)1);
            }
            player.m_9236_().m_46961_(targetPos, handler.isCanDrop(blockState));
        }
    }

    public static boolean isToolTierSufficient(BlockState blockState, Tier toolTier) {
        if (blockState.m_204336_(BlockTags.f_144284_)) {
            return toolTier.m_6604_() >= Tiers.DIAMOND.m_6604_();
        }
        if (blockState.m_204336_(BlockTags.f_144285_)) {
            return toolTier.m_6604_() >= Tiers.IRON.m_6604_();
        }
        if (blockState.m_204336_(BlockTags.f_144286_)) {
            return toolTier.m_6604_() >= Tiers.STONE.m_6604_();
        }
        return true;
    }

    private static boolean isMineable(BlockState blockState) {
        return true;
    }

    private static boolean isCanDrop(BlockState blockState) {
        return blockState.m_204336_(BlockTags.f_144282_) || blockState.m_204336_(BlockTags.f_144283_);
    }

    private static boolean isMineableAxe(BlockState blockState) {
        return blockState.m_204336_(BlockTags.f_144280_) || blockState.m_204336_(BlockTags.f_144281_);
    }

    private static boolean isCanDropAxe(BlockState blockState) {
        return blockState.m_204336_(BlockTags.f_144280_) || blockState.m_204336_(BlockTags.f_144281_);
    }

    private static Direction[] getPlaneDirections(Direction face) {
        Direction[] directionArray;
        switch (face.m_122434_()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Y: {
                Direction[] directionArray2 = new Direction[2];
                directionArray2[0] = Direction.EAST;
                directionArray = directionArray2;
                directionArray2[1] = Direction.SOUTH;
                break;
            }
            case Z: {
                Direction[] directionArray3 = new Direction[2];
                directionArray3[0] = Direction.UP;
                directionArray = directionArray3;
                directionArray3[1] = Direction.EAST;
                break;
            }
            case X: {
                Direction[] directionArray4 = new Direction[2];
                directionArray4[0] = Direction.UP;
                directionArray = directionArray4;
                directionArray4[1] = Direction.SOUTH;
            }
        }
        return directionArray;
    }
}

