/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.client.animators;

import com.nukateam.cgs.common.faundation.item.guns.HammerItem;
import com.nukateam.ntgl.client.animators.GunAnimator;
import com.nukateam.ntgl.client.render.renderers.weapon.DynamicGunRenderer;
import com.nukateam.ntgl.client.util.util.TransformUtils;
import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import java.util.ArrayList;
import java.util.List;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class HammerAnimator
extends GunAnimator {
    public static final String MELEE_POWER_END = "melee_power_end";
    public static final String MELEE_POWER_END2 = "melee_power_end2";
    public static final String MELEE_POWER = "melee_power";
    public static final String RELOAD_SHOT = "reload_shot";
    public static final String RELOAD_SHOT_EMPTY = "reload_shot_empty";
    private boolean isPowered = false;
    private int ammoCount;
    private boolean isShotPowered;
    private GunData data;

    public HammerAnimator(ItemDisplayContext transformType, DynamicGunRenderer<GunAnimator> renderer) {
        super(transformType, renderer);
    }

    protected void tickStart() {
        super.tickStart();
        if (this.itemStack != null && !this.itemStack.m_41619_()) {
            this.data = this.getGunData();
        }
        this.ammoCount = GunStateHelper.getAmmoCount((GunData)this.data);
        this.isShotPowered = this.isShotPowered();
    }

    protected RawAnimation getMeleeDelayAnimation(AnimationState<GunAnimator> event) {
        if (TransformUtils.isFirstPerson((ItemDisplayContext)this.transformType)) {
            if (HammerItem.isPowered(this.data)) {
                this.isPowered = true;
                RawAnimation animation = this.playGunAnim(MELEE_POWER, Animation.LoopType.HOLD_ON_LAST_FRAME);
                this.animationHelper.syncAnimation(event, MELEE_POWER, this.meleeDelay);
                return animation;
            }
            this.isPowered = false;
        }
        return super.getMeleeDelayAnimation(event);
    }

    protected RawAnimation getMeleeCooldownAnimation(AnimationState<GunAnimator> event) {
        if (TransformUtils.isFirstPerson((ItemDisplayContext)this.transformType) && this.isPowered) {
            if (!this.animationHelper.hasAnimation(MELEE_POWER_END)) {
                return this.getHoldAnimation(event);
            }
            ArrayList<String> animations = new ArrayList<String>(List.of(MELEE_POWER_END));
            RawAnimation animation = RawAnimation.begin().then(this.getGunAnim(MELEE_POWER_END), Animation.LoopType.PLAY_ONCE);
            if (this.isShotPowered) {
                animation.then(this.getGunAnim(MELEE_POWER_END2), Animation.LoopType.PLAY_ONCE);
                animations.add(MELEE_POWER_END2);
            }
            this.animationHelper.syncAnimation(event, this.meleeCooldown, animations);
            return animation;
        }
        return super.getMeleeCooldownAnimation(event);
    }

    protected RawAnimation getDefaultReloadAnimation(AnimationState<GunAnimator> event) {
        if (this.isShotPowered()) {
            ArrayList<String> animations = new ArrayList<String>(List.of(RELOAD_SHOT));
            RawAnimation animation = RawAnimation.begin().then(this.getGunAnim(RELOAD_SHOT), Animation.LoopType.PLAY_ONCE);
            if (this.ammoCount == 0) {
                animation.then(this.getGunAnim(RELOAD_SHOT_EMPTY), Animation.LoopType.PLAY_ONCE);
                animations.add(RELOAD_SHOT_EMPTY);
            }
            this.animationHelper.syncAnimation(event, this.reloadTime, animations);
            return animation;
        }
        return super.getDefaultReloadAnimation(event);
    }

    private boolean isShotPowered() {
        return this.getStack().m_41720_() instanceof WeaponItem && GunStateHelper.hasAttachmentEquipped((ItemStack)this.getStack(), (AttachmentType)AttachmentType.MAGAZINE);
    }

    protected RawAnimation getHoldAnimation(AnimationState<GunAnimator> event) {
        if (TransformUtils.isFirstPerson((ItemDisplayContext)this.transformType)) {
            return super.getHoldAnimation(event);
        }
        return null;
    }
}

