/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.faundation.item.guns;

import com.nukateam.cgs.client.renderers.BaseGunRenderer;
import com.nukateam.cgs.common.utils.GunUtils;
import com.nukateam.geo.render.DynamicGeoItemRenderer;
import com.nukateam.ntgl.client.animators.GunAnimator;
import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.AmmoHolders;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.util.interfaces.IGunModifier;
import com.nukateam.ntgl.common.util.util.FuelUtils;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class CgsGunItem
extends WeaponItem {
    private final Lazy<BaseGunRenderer> RENDERER = Lazy.of(() -> new BaseGunRenderer());

    public CgsGunItem(Item.Properties properties, IGunModifier ... modifiers) {
        super(properties, modifiers);
    }

    @OnlyIn(value=Dist.CLIENT)
    public DynamicGeoItemRenderer<GunAnimator> getRenderer() {
        return (DynamicGeoItemRenderer)this.RENDERER.get();
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public void m_6883_(ItemStack gun, Level level, Entity entity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(gun, level, entity, pSlotId, pIsSelected);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            GunData gunData = new GunData(gun, livingEntity);
            CgsGunItem.onEngineTick(gunData);
            CgsGunItem.fillWater(gunData);
        }
    }

    public boolean m_142305_(ItemStack gun, ItemStack fuel, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action == ClickAction.SECONDARY) {
            GunUtils.playAttachSound(player, 0.5f);
            return GunUtils.fillFuel(gun, player, fuel);
        }
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, worldIn, tooltip, flag);
        GunData gunData = new GunData(stack, null);
        Set fuelTypes = GunModifierHelper.getAllFuel((GunData)gunData);
        if (!fuelTypes.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"info.cgs.fuel").m_130940_(ChatFormatting.GRAY));
        }
    }

    private static void onEngineTick(GunData data) {
        Set fuel = GunModifierHelper.getAllFuel((GunData)data);
        if (!fuel.isEmpty() && CgsGunItem.isInHand(data) && fuel.contains(AmmoHolders.BURNABLE)) {
            FuelUtils.addFuel((GunData)data, (AmmoHolder)AmmoHolders.BURNABLE, (int)-1);
        }
    }

    private static void fillWater(GunData gunData) {
        Set types = GunModifierHelper.getAllFuel((GunData)gunData);
        if (gunData.shooter.m_20069_() && types.contains(AmmoHolders.WATER)) {
            Integer maxWater = GunModifierHelper.getMaxFuel((ResourceLocation)AmmoHolders.WATER.getId(), (GunData)gunData);
            FuelUtils.setFuel((ItemStack)gunData.gun, (AmmoHolder)AmmoHolders.WATER, (int)maxWater);
        }
    }

    private static boolean isInHand(GunData data) {
        ItemStack mainHand = data.shooter.m_21205_();
        ItemStack offHand = data.shooter.m_21206_();
        boolean oneHanded1 = GunStateHelper.isOneHanded((GunData)new GunData(mainHand, data.shooter));
        boolean oneHanded2 = GunStateHelper.isOneHanded((GunData)new GunData(offHand, data.shooter));
        return mainHand == data.gun || offHand == data.gun && oneHanded1 && oneHanded2;
    }
}

