/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.ntgl;

import com.nukateam.cgs.common.faundation.registry.CgsSounds;
import com.nukateam.cgs.common.faundation.registry.items.AttachmentItems;
import com.nukateam.cgs.common.faundation.registry.items.CgsWeapons;
import com.nukateam.cgs.common.faundation.registry.items.ModItems;
import com.nukateam.cgs.common.ntgl.CgsAmmo;
import com.nukateam.cgs.common.ntgl.CgsProjectileTypes;
import com.nukateam.cgs.common.utils.GunUtils;
import com.nukateam.example.common.registery.GunModifiers;
import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.attachment.impl.Scope;
import com.nukateam.ntgl.common.data.config.ProjectileConfig;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.AmmoHolders;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.data.holders.FireMode;
import com.nukateam.ntgl.common.data.holders.GripType;
import com.nukateam.ntgl.common.data.holders.LoadingType;
import com.nukateam.ntgl.common.util.interfaces.IGunModifier;
import com.nukateam.ntgl.common.util.util.FuelUtils;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AttachmentMods {
    public static final Scope LONG_SCOPE = Scope.builder().modifiers(new IGunModifier[]{GunModifiers.SLOWER_ADS}).aimFovModifier(0.25f).overlay().build();
    public static final ProjectileConfig FLAME_PROJECTILE = ProjectileConfig.Builder.create().setProjectileType(CgsProjectileTypes.FIREBALL).setDamage(0.2f).setProjectileLife(10).setProjectileSpeed(1.5f).setProjectileAmount(6).setSpread(15.0f).build();
    public static final ProjectileConfig SUPER_FLAME_PROJECTILE = ProjectileConfig.Builder.create().setProjectileType(CgsProjectileTypes.FIREBALL).setDamage(1.0f).setProjectileLife(10).setProjectileSpeed(2.5f).setProjectileAmount(8).setSpread(10.0f).build();
    public static final IGunModifier STEAM_ENGINE_MODIFIERS = new IGunModifier(){

        public ProjectileConfig modifyProjectile(ProjectileConfig value, GunData data) {
            if (data.gun == null) {
                return value;
            }
            if (data.gun.m_41720_() == CgsWeapons.BLAZEGUN.get()) {
                if (GunStateHelper.getCurrentAmmo((GunData)data) == CgsAmmo.BLAZE_CAKE) {
                    return SUPER_FLAME_PROJECTILE;
                }
                return FLAME_PROJECTILE;
            }
            return value;
        }

        public int modifyFireRate(int rate, GunData data) {
            if (data.gun == null) {
                return rate;
            }
            if (data.gun.m_41720_() == CgsWeapons.NAILGUN.get()) {
                return rate * 2;
            }
            if (data.gun.m_41720_() == CgsWeapons.GATLING.get() && FuelUtils.hasFuel((GunData)data)) {
                return rate / 2;
            }
            if (data.gun.m_41720_() == CgsWeapons.BLAZEGUN.get()) {
                if (GunStateHelper.getCurrentAmmo((GunData)data) == CgsAmmo.BLAZE_CAKE) {
                    return 1;
                }
                return 2;
            }
            return rate;
        }

        public int modifyFireDelay(int chargeTime, GunData data) {
            if (data.gun == null) {
                return chargeTime;
            }
            if (data.gun.m_41720_() == CgsWeapons.GATLING.get() && FuelUtils.hasFuel((GunData)data)) {
                return 0;
            }
            return super.modifyFireDelay(chargeTime, data);
        }

        public float modifyMovementSpeed(float value, GunData data) {
            if (data.gun == null) {
                return value;
            }
            if (data.gun.m_41720_() == CgsWeapons.GATLING.get()) {
                return value - 0.2f;
            }
            return super.modifyMovementSpeed(value, data);
        }

        public float modifyDamage(float damage, GunData data) {
            if (data.gun == null) {
                return damage;
            }
            if (data.gun.m_41720_() == CgsWeapons.NAILGUN.get()) {
                return damage * 2.0f;
            }
            return super.modifyDamage(damage, data);
        }

        public float recoilModifier(GunData data) {
            if (data.gun != null && data.gun.m_41720_() == CgsWeapons.NAILGUN.get()) {
                return 2.0f;
            }
            return super.recoilModifier(data);
        }

        public float kickModifier(GunData data) {
            if (data.gun != null && data.gun.m_41720_() == CgsWeapons.NAILGUN.get()) {
                return 2.0f;
            }
            return super.kickModifier(data);
        }

        public float modifyProjectileSpread(float spread, GunData data) {
            if (data.gun == null) {
                return spread;
            }
            if (data.gun.m_41720_() == CgsWeapons.GATLING.get() && FuelUtils.hasFuel((GunData)data)) {
                return spread + 8.0f;
            }
            return spread;
        }

        public Set<AmmoHolder> modifyFuelItems(Set<AmmoHolder> fuel, GunData data) {
            if (data.gun == null) {
                return fuel;
            }
            if (data.gun.m_41720_() == CgsWeapons.BLAZEGUN.get()) {
                return Set.of(AmmoHolders.WATER);
            }
            return Set.of(AmmoHolders.BURNABLE, AmmoHolders.WATER);
        }

        public GripType modifyGripType(GripType gripType, GunData data) {
            if (data != null && data.gun != null) {
                if (data.gun.m_41720_() == CgsWeapons.NAILGUN.get()) {
                    return GripType.TWO_HANDED;
                }
                if (data.gun.m_41720_() == CgsWeapons.GATLING.get()) {
                    return this.getGatlingGripType(gripType, data);
                }
            }
            return super.modifyGripType(gripType, data);
        }

        public ResourceLocation modifyFireSound(ResourceLocation sound, GunData data) {
            if (data.gun != null && data.gun.m_41720_() == CgsWeapons.NAILGUN.get()) {
                return ((SoundEvent)CgsSounds.NAILGUN_FIRE_STEAM.get()).m_11660_();
            }
            return super.modifyFireSound(sound, data);
        }

        private GripType getGatlingGripType(GripType gripType, GunData data) {
            Item drumItem;
            Item magazineItem;
            if (data.shooter != null && data.gun != null && (magazineItem = GunStateHelper.getAttachmentItem((AttachmentType)AttachmentType.MAGAZINE, (ItemStack)data.gun).m_41720_()) != (drumItem = (Item)AttachmentItems.GATLING_DRUM.get()) && FuelUtils.hasFuel((GunData)data) && data.shooter.m_21023_(MobEffects.f_19600_)) {
                return GripType.ONE_HANDED;
            }
            return gripType;
        }
    };
    public static final IGunModifier GATLING_DRUM_MODIFIERS = new IGunModifier(){

        public int modifyMaxAmmo(int maxAmmo, GunData data) {
            return 300;
        }

        public float modifyProjectileSpread(float spread, GunData data) {
            return spread * 2.0f;
        }

        public float modifyMovementSpeed(float value, GunData data) {
            return value - 0.1f;
        }
    };
    public static final IGunModifier BAYONET_MODIFIERS = new IGunModifier(){

        public boolean modifyCanMelee(boolean value, GunData data) {
            return true;
        }

        public float modifyMeleeDamage(float value, GunData data) {
            return 10.0f;
        }

        public float modifyMeleeAngle(float value, GunData data) {
            if (data.gun == null) {
                return value;
            }
            ItemStack barrel = GunStateHelper.getAttachmentItem((AttachmentType)AttachmentType.BARREL, (ItemStack)data.gun);
            if (barrel.m_41720_() == AttachmentItems.FLINTLOCK_LONG_BARREL.get()) {
                return 20.0f;
            }
            return 120.0f;
        }

        public float modifyMeleeDistance(float value, GunData data) {
            if (data.gun == null) {
                return value;
            }
            ItemStack barrel = GunStateHelper.getAttachmentItem((AttachmentType)AttachmentType.BARREL, (ItemStack)data.gun);
            if (barrel.m_41720_() == AttachmentItems.FLINTLOCK_LONG_BARREL.get()) {
                return 5.0f;
            }
            return 3.0f;
        }

        public int modifyMeleeDelay(int time, GunData data) {
            return 5;
        }

        public int modifyMeleeCooldown(int time, GunData data) {
            return 8;
        }
    };
    public static final IGunModifier BELT_MODIFIERS = new IGunModifier(){

        public int modifyReloadTime(int reloadTime, GunData data) {
            return 20;
        }

        public int modifyMaxAmmo(int maxAmmo, GunData data) {
            return 12;
        }

        public double modifyAimDownSightSpeed(double speed, GunData data) {
            return speed * 0.75;
        }

        public LoadingType modifyLoadingType(LoadingType loadingType, GunData data) {
            return LoadingType.PER_CARTRIDGE;
        }
    };
    public static final IGunModifier AUTO_FIRE = new IGunModifier(){

        public int modifyFireDelay(int chargeTime, GunData data) {
            return 0;
        }

        public Set<FireMode> modifyFireModes(Set<FireMode> fireMode, GunData data) {
            return new LinkedHashSet<FireMode>(List.of(FireMode.AUTO, FireMode.SEMI_AUTO));
        }

        public float modifyProjectileSpread(float spread, GunData data) {
            return spread * 1.5f;
        }

        public int modifyFireRate(int rate, GunData data) {
            return rate / 2;
        }
    };
    public static final IGunModifier LONG_BARREL = new IGunModifier(){

        public GripType modifyGripType(GripType gripType, GunData data) {
            if (data.gun != null && data.gun.m_41720_() == CgsWeapons.REVOLVER.get()) {
                if (GunStateHelper.hasAttachmentEquipped((ItemStack)data.gun, (AttachmentType)AttachmentType.STOCK)) {
                    return GripType.TWO_HANDED;
                }
                return gripType;
            }
            return GripType.TWO_HANDED;
        }

        public float modifyDamage(float damage, GunData data) {
            return damage * 1.5f;
        }

        public double modifyProjectileSpeed(double speed, GunData data) {
            return speed * 3.0;
        }

        public double modifyAimDownSightSpeed(double speed, GunData data) {
            return speed * 0.95;
        }
    };
    public static final IGunModifier STOCK = new IGunModifier(){

        public float recoilModifier(GunData data) {
            return 0.1f;
        }

        public float kickModifier(GunData data) {
            return 0.1f;
        }

        public float modifyProjectileSpread(float spread, GunData data) {
            return spread * 0.25f;
        }

        public double modifyAimDownSightSpeed(double speed, GunData data) {
            return speed * (double)0.8f;
        }
    };
    public static final IGunModifier SHOTGUN_MODIFIER = new IGunModifier(){

        public int modifyFireRate(int rate, GunData data) {
            if (data.gun == null) {
                return rate;
            }
            int cock = GunUtils.getCock(data.gun);
            if (GunStateHelper.getFireMode((GunData)data) == FireMode.MULTI && cock == 2) {
                return 20;
            }
            if (cock == 1) {
                return 20;
            }
            return rate;
        }
    };
    public static final IGunModifier SHOTGUN_DRUM_MODIFIER = new IGunModifier(){

        public int modifyMaxAmmo(int maxAmmo, GunData data) {
            return 8;
        }

        public int modifyReloadTime(int reloadTime, GunData data) {
            return 80;
        }
    };
    public static final IGunModifier SHOTGUN_PUMP_MODIFIER = new IGunModifier(){

        public LoadingType modifyLoadingType(LoadingType loadingType, GunData data) {
            return LoadingType.PER_CARTRIDGE;
        }

        public int modifyMaxAmmo(int maxAmmo, GunData data) {
            return 10;
        }

        public int modifyReloadStart(int reloadTime, GunData data) {
            return 8;
        }

        public int modifyReloadTime(int reloadTime, GunData data) {
            return 12;
        }

        public int modifyReloadEnd(int reloadTime, GunData data) {
            return 20;
        }

        public GripType modifyGripType(GripType gripType, GunData data) {
            return GripType.TWO_HANDED;
        }
    };
    public static final IGunModifier SHOTGUN_LONG_BARREL = new IGunModifier(){

        public GripType modifyGripType(GripType gripType, GunData data) {
            return GripType.TWO_HANDED;
        }

        public float modifyProjectileSpread(float spread, GunData data) {
            return spread * 0.5f;
        }
    };
    public static final IGunModifier SHOTGUN_SPREAD_BARREL = new IGunModifier(){

        public float modifyDamage(float damage, GunData data) {
            return damage * 1.5f;
        }

        public float modifyProjectileSpread(float spread, GunData data) {
            return spread * 2.0f;
        }
    };
    public static final IGunModifier NAILGUN_SPLIT_BARREL = new IGunModifier(){
        public static final int AMMO_PER_SHOT = 4;

        public float modifyDamage(float damage, GunData data) {
            return damage * (float)13.getProjectileAmount(data);
        }

        public float modifyProjectileSpread(float spread, GunData data) {
            return spread * 8.0f;
        }

        public int modifyProjectileAmount(int amount, GunData data) {
            return 13.getProjectileAmount(data);
        }

        private static int getProjectileAmount(GunData data) {
            return Math.min(4, GunStateHelper.getAmmoCount((GunData)data));
        }

        public int modifyAmmoPerShot(int ammoPerShot, GunData data) {
            return 4;
        }

        public int modifyFireRate(int rate, GunData data) {
            return (int)((double)rate * 2.5);
        }
    };
    public static final IGunModifier RECIEVER = new IGunModifier(){

        public int modifyMaxAmmo(int maxAmmo, GunData data) {
            return 6;
        }

        public int modifyAmmoPerShot(int ammoPerShot, GunData data) {
            return 1;
        }

        public float modifyMeleeDamage(float damage, GunData data) {
            GunStateHelper.getAmmoCount((GunData)data);
            return damage * 2.0f;
        }

        public Set<AmmoHolder> modifyAmmoItems(Set<AmmoHolder> item, GunData data) {
            return Set.of(AmmoHolder.getType((ResourceLocation)ModItems.SHOTGUN_ROUND_BLANK.getId()));
        }
    };
    public static final IGunModifier HAMMER_HEAD = new IGunModifier(){

        public int modifyMeleeMaxTargets(int value, GunData data) {
            return 6;
        }

        public float modifyMeleeDamage(float damage, GunData data) {
            return damage + 2.0f;
        }

        public float modifyMeleeAngle(float value, GunData data) {
            return 80.0f;
        }
    };
    public static final IGunModifier AXE_HEAD = new IGunModifier(){

        public int modifyMeleeMaxTargets(int value, GunData data) {
            return 1;
        }

        public float modifyMeleeDamage(float damage, GunData data) {
            return damage + 4.0f;
        }
    };
    public static final IGunModifier BALLISTAZOOKA = new IGunModifier(){

        public Set<FireMode> modifyFireModes(Set<FireMode> fireMode, GunData data) {
            return new LinkedHashSet<FireMode>(List.of(FireMode.SEMI_AUTO));
        }

        public int modifyMaxAmmo(int maxAmmo, GunData data) {
            return 1;
        }

        public int modifyFireRate(int rate, GunData data) {
            return 15;
        }

        public float modifyProjectileSpread(float spread, GunData data) {
            return 1.0f;
        }

        public double modifyProjectileSpeed(double speed, GunData data) {
            return 40.0;
        }

        public int modifyReloadTime(int reloadTime, GunData data) {
            if (FuelUtils.hasFuel((GunData)data)) {
                return 80;
            }
            return 140;
        }

        public Set<AmmoHolder> modifyFuelItems(Set<AmmoHolder> secondaryAmmo, GunData data) {
            return Set.of(CgsAmmo.AIR);
        }

        public Set<AmmoHolder> modifyAmmoItems(Set<AmmoHolder> item, GunData data) {
            return Set.of(AmmoHolder.getType((ResourceLocation)ModItems.SPEAR.getId()));
        }

        public ResourceLocation modifyFireSound(ResourceLocation sound, GunData data) {
            return CgsSounds.BALLISTA_FIRE.getId();
        }

        public boolean modifyAutoReloading(boolean autoReload, GunData data) {
            return true;
        }
    };
    public static final IGunModifier AUTO_LAUNCHER = new IGunModifier(){

        public Set<FireMode> modifyFireModes(Set<FireMode> fireMode, GunData data) {
            return new LinkedHashSet<FireMode>(List.of(FireMode.AUTO));
        }

        public int modifyFuelAmountPerUse(ResourceLocation ammo, int value, GunData data) {
            if (ammo.equals((Object)CgsAmmo.AIR.getId())) {
                return 1;
            }
            return value;
        }

        public int modifyMaxAmmo(int maxAmmo, GunData data) {
            return 30;
        }

        public Set<AmmoHolder> modifyAmmoItems(Set<AmmoHolder> item, GunData data) {
            return Set.of(AmmoHolder.getType((ResourceLocation)ModItems.SMALL_ROCKET.getId()));
        }

        public int modifyFireRate(int rate, GunData data) {
            return 2;
        }

        public int modifyReloadTime(int reloadTime, GunData data) {
            return 100;
        }

        public Set<AmmoHolder> modifyFuelItems(Set<AmmoHolder> secondaryAmmo, GunData data) {
            return Set.of(CgsAmmo.AIR);
        }
    };
    public static final IGunModifier BIG_BAYONET = new IGunModifier(){

        public boolean modifyCanMelee(boolean value, GunData data) {
            return true;
        }

        public float modifyMeleeDamage(float value, GunData data) {
            return 12.0f;
        }
    };
}

