/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.client.animators;

import com.nukateam.cgs.common.ntgl.CgsAttachmentTypes;
import com.nukateam.ntgl.client.animators.GunAnimator;
import com.nukateam.ntgl.client.render.renderers.weapon.DynamicGunRenderer;
import com.nukateam.ntgl.client.util.util.TransformUtils;
import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.util.util.FuelUtils;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import com.simibubi.create.AllSoundEvents;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class EngineAnimator
extends GunAnimator {
    public static final String HANDLE = "handle";
    public static final String VOID = "void";
    public static final String ENGINE = "engine";
    protected final AnimationController<GunAnimator> ENGINE_CONTROLLER = this.createController("engine_controller", this.animateEngine());
    protected int aTicks = 0;
    protected int ticks = 0;
    protected int rate;

    public EngineAnimator(ItemDisplayContext transformType, DynamicGunRenderer<GunAnimator> renderer) {
        super(transformType, renderer);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        super.registerControllers(controllerRegistrar);
        controllerRegistrar.add(new AnimationController[]{this.ENGINE_CONTROLLER});
    }

    protected void tickStart() {
        if (GunModifierHelper.isGun((ItemStack)this.getStack())) {
            super.tickStart();
            ++this.ticks;
            GunData data = new GunData(this.getStack(), this.getEntity());
            this.rate = GunModifierHelper.getRate((GunData)data);
            this.playEngineSound();
            this.aTicks = Math.max(this.aTicks - 1, 0);
        }
    }

    protected AnimationController.AnimationStateHandler<GunAnimator> animateEngine() {
        return event -> {
            if (this.isEngineWorking()) {
                event.getController().setAnimationSpeed(1.0);
                RawAnimation animation = RawAnimation.begin().then(ENGINE, Animation.LoopType.LOOP);
                if (this.shootingHandler.isOnCooldown(this.getEntity(), this.getArm())) {
                    this.animationHelper.syncAnimation(event, ENGINE, this.rate * this.getBarrelAmount());
                }
                return event.setAndContinue(animation);
            }
            return PlayState.STOP;
        };
    }

    private void playEngineSound() {
        if (this.shouldPlayEngineSound()) {
            float volume;
            LocalPlayer player = this.minecraft.f_91074_;
            boolean isShooting = this.shootingHandler.isShooting(this.getEntity(), this.getArm());
            float pitch = 1.18f - this.minecraft.f_91073_.f_46441_.m_188501_() * 0.25f;
            float f = volume = isShooting ? 6.0f : 0.5f;
            assert (player != null);
            this.minecraft.f_91073_.m_7785_(player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, SoundEvents.f_144098_, SoundSource.BLOCKS, volume, pitch, false);
            AllSoundEvents.STEAM.playAt((Level)this.minecraft.f_91073_, player.m_20182_(), volume / 16.0f, 0.8f, false);
        }
    }

    private boolean shouldPlayEngineSound() {
        boolean isShooting = this.shootingHandler.isShooting(this.getEntity(), this.arm);
        int frequency = isShooting ? 5 : 20;
        boolean tick = this.ticks % frequency == 0;
        return this.isEngineWorking() && tick;
    }

    private boolean isEngineWorking() {
        LocalPlayer player = this.minecraft.f_91074_;
        if (player == null) {
            return false;
        }
        GunData mainGunData = new GunData(this.getEntity().m_21205_(), this.getEntity());
        GunData offGunData = new GunData(this.getEntity().m_21206_(), this.getEntity());
        boolean i1 = GunStateHelper.isOneHanded((GunData)mainGunData);
        boolean i2 = GunStateHelper.isOneHanded((GunData)offGunData);
        InteractionHand arm = this.getArm();
        EngineAnimator engineAnimator = this;
        boolean isNotPaused = !engineAnimator.minecraft.m_91087_().m_91104_();
        boolean isVisible = arm == InteractionHand.MAIN_HAND || arm == InteractionHand.OFF_HAND && i1 && i2;
        boolean hasEngine = this.hasEngine();
        boolean isHandTransform = TransformUtils.isHandTransform((ItemDisplayContext)this.transformType);
        boolean hasGunInHands = this.hasGunInHands(player);
        boolean hasFuel = FuelUtils.hasFuel((GunData)new GunData(this.getStack(), this.getEntity()));
        return hasEngine && hasFuel && isVisible && isHandTransform && hasGunInHands && isNotPaused;
    }

    protected boolean hasGunInHands(LocalPlayer player) {
        return player.m_21205_().m_41720_() == this.getStack().m_41720_() || player.m_21206_().m_41720_() == this.getStack().m_41720_();
    }

    protected boolean hasEngine() {
        return !this.getStack().m_41619_() && GunStateHelper.hasAttachmentEquipped((ItemStack)this.getStack(), (AttachmentType)CgsAttachmentTypes.ENGINE);
    }
}

