/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.client.animators;

import com.nukateam.cgs.client.animators.EngineAnimator;
import com.nukateam.cgs.common.faundation.registry.AttachmentItems;
import com.nukateam.cgs.common.ntgl.CgsAttachmentTypes;
import com.nukateam.geo.render.DynamicGeoItemRenderer;
import com.nukateam.ntgl.client.animators.GunAnimator;
import com.nukateam.ntgl.client.util.handler.ClientReloadHandler;
import com.nukateam.ntgl.common.base.holders.AttachmentType;
import com.nukateam.ntgl.common.base.utils.FuelUtils;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.foundation.item.GunItem;
import com.nukateam.ntgl.common.util.util.Cycler;
import com.nukateam.ntgl.common.util.util.GunData;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class GatlingAnimator
extends EngineAnimator {
    public static final String HANDLE = "handle";
    public static final String VOID = "void";
    public static final String RELOAD_DRUM = "reload_drum";
    protected Cycler handleCycler = new Cycler(1, this.getBarrelAmount());
    private boolean hasDrum;
    protected final AnimationController<GunAnimator> HANDLE_CONTROLLER = this.createController("handle_controller", this.animateHandle());
    protected final AnimationController<GunAnimator> GATLING_TRIGGER = this.createController("gatling_trigger", event -> PlayState.CONTINUE).triggerableAnim("handle", RawAnimation.begin().then("handle", Animation.LoopType.PLAY_ONCE)).triggerableAnim("void", RawAnimation.begin().then("void", Animation.LoopType.PLAY_ONCE));

    public GatlingAnimator(ItemDisplayContext transformType, DynamicGeoItemRenderer<GunAnimator> renderer) {
        super(transformType, renderer);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        super.registerControllers(controllerRegistrar);
        controllerRegistrar.add(new AnimationController[]{this.HANDLE_CONTROLLER});
        controllerRegistrar.add(new AnimationController[]{this.GATLING_TRIGGER});
    }

    protected int getBarrelAmount() {
        return 4;
    }

    @Override
    protected void tickStart() {
        super.tickStart();
        ItemStack magazine = Gun.getAttachmentItem((AttachmentType)AttachmentType.MAGAZINE, (ItemStack)this.getStack());
        this.hasDrum = magazine.m_150930_((Item)AttachmentItems.GATLING_DRUM.get());
        float cooldown = this.shootingHandler.getCooldown(this.getEntity(), this.arm);
        if (cooldown == (float)this.rate) {
            this.handleCycler.cycle();
        }
    }

    protected RawAnimation getReloadingAnimation(AnimationState<GunAnimator> event) {
        this.HANDLE_CONTROLLER.setAnimation(RawAnimation.begin().then(VOID, Animation.LoopType.PLAY_ONCE));
        return super.getReloadingAnimation(event);
    }

    protected RawAnimation getDefaultReloadAnimation(AnimationState<GunAnimator> event) {
        if (this.hasDrum) {
            GunData data = new GunData(this.getStack(), this.getEntity());
            int time = GunModifierHelper.getReloadTime((GunData)data);
            this.animationHelper.syncAnimation(event, RELOAD_DRUM, time);
            return RawAnimation.begin().then(RELOAD_DRUM, Animation.LoopType.LOOP);
        }
        return super.getDefaultReloadAnimation(event);
    }

    protected AnimationController.AnimationStateHandler<GunAnimator> animateHandle() {
        return event -> {
            Gun gun = ((GunItem)this.getStack().m_41720_()).getGun();
            RawAnimation animation = RawAnimation.begin();
            boolean hasEngine = Gun.hasAttachmentEquipped((ItemStack)this.getStack(), (Gun)gun, (AttachmentType)CgsAttachmentTypes.ENGINE);
            boolean hasFuel = FuelUtils.hasFuel((GunData)this.getGunData());
            if (hasEngine && hasFuel || this.hasAnimationPlaying((AnimationController<GunAnimator>)this.MAIN_CONTROLLER, "reload")) {
                return PlayState.STOP;
            }
            ClientReloadHandler reloadHandler = ClientReloadHandler.get();
            if (!reloadHandler.isReloading(this.getEntity(), this.getArm())) {
                PlayState handleAnim = this.getCycledAnimation(event, HANDLE, this.handleCycler);
                return handleAnim;
            }
            animation = RawAnimation.begin().then(VOID, Animation.LoopType.PLAY_ONCE);
            return event.setAndContinue(animation);
        };
    }

    private boolean hasAnimationPlaying(AnimationController<GunAnimator> controller, String name) {
        return controller.getCurrentAnimation().animation().name().equals(name);
    }
}

