/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.datagen;

import com.nukateam.cgs.common.datagen.providers.CgsMechanicalCraftingRecipeGen;
import com.nukateam.cgs.common.datagen.providers.ModBlockStateProvider;
import com.nukateam.cgs.common.datagen.providers.ModBlockTagGenerator;
import com.nukateam.cgs.common.datagen.providers.ModItemModelProvider;
import com.nukateam.cgs.common.datagen.providers.ModItemTagGenerator;
import com.nukateam.cgs.common.datagen.providers.ModLootTableProvider;
import com.nukateam.cgs.common.datagen.providers.ModPoiTypeTagsProvider;
import com.nukateam.cgs.common.datagen.providers.ModRecipeProvider;
import com.nukateam.cgs.common.datagen.providers.ModWorldGenProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cgs", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new CgsMechanicalCraftingRecipeGen(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)ModLootTableProvider.create(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, fileHelper));
        ModBlockTagGenerator blockTagGenerator = (ModBlockTagGenerator)generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagGenerator(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagGenerator(packOutput, lookupProvider, blockTagGenerator.m_274426_(), fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModPoiTypeTagsProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModWorldGenProvider(packOutput, lookupProvider));
    }
}

