/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.datagen.providers;

import com.nukateam.cgs.common.datagen.DataGenConfig;
import com.nukateam.cgs.common.datagen.DataGenUtils;
import com.nukateam.cgs.common.datagen.annotations.BlockStateGen;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "cgs", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (Class clazz : DataGenConfig.dataGenClasses) {
            DataGenUtils.handleFields(clazz, BlockStateGen.class, this::handleDataGenField);
        }
    }

    private void handleDataGenField(Object obj, BlockStateGen annotation) {
        RegistryObject registryObject;
        if (obj instanceof RegistryObject && (registryObject = (RegistryObject)obj).get() instanceof Block) {
            this.blockWithItem((RegistryObject<Block>)registryObject);
        }
    }

    private void saplingBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlock((Block)blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().cross(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).m_135815_(), this.blockTexture((Block)blockRegistryObject.get()))).renderType("cutout"));
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(this.name(signBlock), texture);
        this.hangingSignBlock(signBlock, wallSignBlock, (ModelFile)sign);
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ModelFile sign) {
        this.simpleBlock(signBlock, sign);
        this.simpleBlock(wallSignBlock, sign);
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    private void leavesBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).m_135815_(), new ResourceLocation("minecraft:block/leaves"), "all", this.blockTexture((Block)blockRegistryObject.get()))).renderType("cutout"));
    }

    private void blockItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockItem((Block)blockRegistryObject.get(), (ModelFile)new ModelFile.UncheckedModelFile("cgs:block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).m_135815_()));
    }

    private void blockWithItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }
}

