/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.datagen.providers;

import com.nukateam.cgs.common.datagen.DataGenConfig;
import com.nukateam.cgs.common.datagen.DataGenUtils;
import com.nukateam.cgs.common.datagen.annotations.ItemModelGen;
import java.util.HashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "cgs", exFileHelper);
    }

    protected void registerModels() {
        for (Class clazz : DataGenConfig.dataGenClasses) {
            DataGenUtils.handleFields(clazz, ItemModelGen.class, this::handleDataGenField);
        }
    }

    private void handleDataGenField(Object obj, ItemModelGen annotation) {
        if (obj instanceof RegistryObject) {
            switch (annotation.type()) {
                case ITEM: {
                    this.genItems((RegistryObject<Item>)((RegistryObject)obj), annotation);
                    break;
                }
                case BLOCK: {
                    this.blockModel((RegistryObject<? extends Block>)((RegistryObject)obj));
                }
            }
        } else if (obj instanceof HashMap) {
            HashMap storage = (HashMap)obj;
            for (RegistryObject item : storage.values()) {
                this.genItems((RegistryObject<Item>)item, annotation);
            }
        }
    }

    private void genItems(RegistryObject<Item> item, ItemModelGen annotation) {
        ModelFile modelFile = this.getModelFile(annotation.parent().getPath());
        switch (annotation.parent()) {
            case SPAWN_EGG: {
                this.spawnEggModel(item, modelFile);
                break;
            }
            default: {
                this.itemModel(item, modelFile, annotation);
            }
        }
    }

    private ModelFile getModelFile(String path) {
        return this.getExistingFile(new ResourceLocation(path));
    }

    private void blockModel(RegistryObject<? extends Block> block) {
        String path = block.getId().m_135815_();
        ResourceLocation loc = this.modLoc("block/" + block.getId().m_135815_());
        this.withExistingParent(path, loc);
    }

    private void blockModel(RegistryObject<? extends Block> block, String suffix) {
        this.withExistingParent(block.getId().m_135815_(), this.modLoc("block/" + block.getId().m_135815_() + "_" + suffix));
    }

    private void blockItemModel(RegistryObject<?> block, RegistryObject<?> textureBlock, ModelFile modelFile) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(block.getId().m_135815_())).parent(modelFile)).texture("layer0", "block/" + textureBlock.getId().m_135815_());
    }

    private ItemModelBuilder itemModel(RegistryObject<?> item, ModelFile modelFile, ItemModelGen dataGen) {
        String path = item.getId().m_135815_();
        Object texture = "item/";
        if (!dataGen.path().isEmpty()) {
            texture = (String)texture + dataGen.path() + "/";
        }
        if (dataGen.ownDir()) {
            texture = (String)texture + path.split("_")[0] + "/";
        }
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent(modelFile)).texture("layer0", (String)texture + item.getId().m_135815_());
    }

    private ItemModelBuilder spawnEggModel(RegistryObject<?> item, ModelFile modelFile) {
        return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getId().m_135815_())).parent(modelFile);
    }

    private void itemModelWithSuffix(RegistryObject<?> item, ModelFile modelFile, String suffix) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getId().m_135815_() + "_" + suffix)).parent(modelFile)).texture("layer0", "item/" + item.getId().m_135815_() + "_" + suffix);
    }

    private ModelFile.ExistingModelFile getModel(RegistryObject<?> item, String suffix) {
        return new ModelFile.ExistingModelFile(this.modLoc("item/" + item.getId().m_135815_() + "_" + suffix), this.existingFileHelper);
    }
}

