/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.ntgl;

import com.nukateam.cgs.common.faundation.registry.AttachmentItems;
import com.nukateam.cgs.common.faundation.registry.ModGuns;
import com.nukateam.cgs.common.faundation.registry.ModSounds;
import com.nukateam.cgs.common.utils.GunUtils;
import com.nukateam.ntgl.common.base.GunModifiers;
import com.nukateam.ntgl.common.base.holders.AttachmentType;
import com.nukateam.ntgl.common.base.holders.FireMode;
import com.nukateam.ntgl.common.base.holders.FuelType;
import com.nukateam.ntgl.common.base.holders.GripType;
import com.nukateam.ntgl.common.base.holders.LoadingType;
import com.nukateam.ntgl.common.base.utils.FuelUtils;
import com.nukateam.ntgl.common.data.attachment.impl.Scope;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.util.interfaces.IGunModifier;
import com.nukateam.ntgl.common.util.util.GunData;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class Attachments {
    public static final int MAX_FUEL = 20000;
    public static final int MAX_WATER = 2000;
    public static final int MAX_AIR = 900;
    public static final Scope SHORT_SCOPE = Scope.builder().aimFovModifier(0.85f).modifiers(new IGunModifier[]{GunModifiers.SLOW_ADS}).build();
    public static final Scope LONG_SCOPE = Scope.builder().modifiers(new IGunModifier[]{GunModifiers.SLOWER_ADS}).aimFovModifier(0.25f).overlay().build();
    public static final IGunModifier STEAM_ENGINE_MODIFIERS = new IGunModifier(){

        public int modifyFireRate(int rate, GunData data) {
            if (data.gun.m_41720_() == ModGuns.NAILGUN.get()) {
                return rate * 2;
            }
            if (data.gun.m_41720_() == ModGuns.GATLING.get() && FuelUtils.hasFuel((GunData)data)) {
                return rate / 2;
            }
            return rate;
        }

        public int modifyFireDelay(int chargeTime, GunData data) {
            if (data.gun.m_41720_() == ModGuns.GATLING.get() && FuelUtils.hasFuel((GunData)data)) {
                return 10;
            }
            return super.modifyFireDelay(chargeTime, data);
        }

        public float modifyDamage(float damage, GunData data) {
            if (data.gun.m_41720_() == ModGuns.NAILGUN.get()) {
                return damage * 2.0f;
            }
            return super.modifyDamage(damage, data);
        }

        public float recoilModifier(GunData data) {
            if (data.gun.m_41720_() == ModGuns.NAILGUN.get()) {
                return 2.0f;
            }
            return super.recoilModifier(data);
        }

        public float kickModifier(GunData data) {
            if (data.gun.m_41720_() == ModGuns.NAILGUN.get()) {
                return 2.0f;
            }
            return super.kickModifier(data);
        }

        public float modifyProjectileSpread(float spread, GunData data) {
            if (data.gun.m_41720_() == ModGuns.GATLING.get() && FuelUtils.hasFuel((GunData)data)) {
                return spread + 8.0f;
            }
            return spread;
        }

        public Set<FuelType> modifyFuel(Set<FuelType> secondaryAmmo, GunData data) {
            return Set.of(FuelType.BURNABLE, FuelType.WATER);
        }

        public int modifyMaxFuel(int max, FuelType type, GunData data) {
            if (type == FuelType.BURNABLE) {
                return 20000;
            }
            if (type == FuelType.WATER) {
                return 2000;
            }
            return max;
        }

        public GripType modifyGripType(GripType gripType, GunData data) {
            if (data != null) {
                if (data.gun.m_41720_() == ModGuns.NAILGUN.get()) {
                    return GripType.TWO_HANDED;
                }
                if (data.gun.m_41720_() == ModGuns.GATLING.get()) {
                    return this.getGatlingGripType(gripType, data);
                }
            }
            return super.modifyGripType(gripType, data);
        }

        public ResourceLocation modifyFireSound(ResourceLocation sound, GunData data) {
            if (data.gun.m_41720_() == ModGuns.NAILGUN.get()) {
                return ((SoundEvent)ModSounds.NAILGUN_FIRE_STEAM.get()).m_11660_();
            }
            return super.modifyFireSound(sound, data);
        }

        private GripType getGatlingGripType(GripType gripType, GunData data) {
            Item drumItem;
            Item magazineItem = Gun.getAttachmentItem((AttachmentType)AttachmentType.MAGAZINE, (ItemStack)data.gun).m_41720_();
            if (magazineItem != (drumItem = (Item)AttachmentItems.GATLING_DRUM.get()) && FuelUtils.hasFuel((GunData)data) && data.shooter.m_21023_(MobEffects.f_19600_)) {
                return GripType.ONE_HANDED;
            }
            return gripType;
        }
    };
    public static final IGunModifier GATLING_DRUM_MODIFIERS = new IGunModifier(){

        public int modifyMaxAmmo(int maxAmmo, GunData data) {
            return 300;
        }

        public float modifyProjectileSpread(float spread, GunData data) {
            return spread * 2.0f;
        }
    };
    public static final IGunModifier BELT_MODIFIERS = new IGunModifier(){

        public int modifyReloadTime(int reloadTime, GunData data) {
            return 20;
        }

        public int modifyMaxAmmo(int maxAmmo, GunData data) {
            return 12;
        }

        public double modifyAimDownSightSpeed(double speed, GunData data) {
            return speed * 0.75;
        }

        public LoadingType modifyLoadingType(LoadingType loadingType, GunData data) {
            return LoadingType.PER_CARTRIDGE;
        }
    };
    public static final IGunModifier AUTO_FIRE = new IGunModifier(){

        public int modifyFireDelay(int chargeTime, GunData data) {
            return 0;
        }

        public Set<FireMode> modifyFireModes(Set<FireMode> fireMode, GunData data) {
            return Set.of(FireMode.AUTO, FireMode.SEMI_AUTO);
        }

        public float modifyProjectileSpread(float spread, GunData data) {
            return spread * 1.5f;
        }

        public int modifyFireRate(int rate, GunData data) {
            return rate / 2;
        }
    };
    public static final IGunModifier LONG_BARREL = new IGunModifier(){

        public GripType modifyGripType(GripType gripType, GunData data) {
            return GripType.TWO_HANDED;
        }

        public float modifyDamage(float damage, GunData data) {
            return damage * 1.5f;
        }

        public double modifyProjectileSpeed(double speed, GunData data) {
            return speed * 3.0;
        }

        public double modifyAimDownSightSpeed(double speed, GunData data) {
            return speed * 0.95;
        }
    };
    public static final IGunModifier AUTO = new IGunModifier(){

        public float modifyProjectileSpread(float spread, GunData data) {
            return spread * 2.0f;
        }
    };
    public static final IGunModifier STOCK = new IGunModifier(){

        public float recoilModifier(GunData data) {
            return 0.1f;
        }

        public float kickModifier(GunData data) {
            return 0.1f;
        }

        public float modifyProjectileSpread(float spread, GunData data) {
            return spread * 0.25f;
        }

        public double modifyAimDownSightSpeed(double speed, GunData data) {
            return speed * (double)0.8f;
        }
    };
    public static final IGunModifier SHOTGUN_MODIFIER = new IGunModifier(){

        public int modifyFireRate(int rate, GunData data) {
            if (!GunUtils.isAmmoEven(data.gun)) {
                return 20;
            }
            return super.modifyFireRate(rate, data);
        }
    };
    public static final IGunModifier SHOTGUN_DRUM_MODIFIER = new IGunModifier(){

        public int modifyMaxAmmo(int maxAmmo, GunData data) {
            return 8;
        }

        public int modifyReloadTime(int reloadTime, GunData data) {
            return 80;
        }
    };
    public static final IGunModifier SHOTGUN_PUMP_MODIFIER = new IGunModifier(){

        public LoadingType modifyLoadingType(LoadingType loadingType, GunData data) {
            return LoadingType.PER_CARTRIDGE;
        }

        public int modifyMaxAmmo(int maxAmmo, GunData data) {
            return 10;
        }

        public int modifyReloadStart(int reloadTime, GunData data) {
            return 8;
        }

        public int modifyReloadTime(int reloadTime, GunData data) {
            return 12;
        }

        public int modifyReloadEnd(int reloadTime, GunData data) {
            return 20;
        }

        public GripType modifyGripType(GripType gripType, GunData data) {
            return GripType.TWO_HANDED;
        }
    };
    public static final IGunModifier SHOTGUN_LONG_BARREL = new IGunModifier(){

        public GripType modifyGripType(GripType gripType, GunData data) {
            return GripType.TWO_HANDED;
        }

        public float modifyProjectileSpread(float spread, GunData data) {
            return spread * 0.5f;
        }
    };
    public static final IGunModifier SHOTGUN_SPREAD_BARREL = new IGunModifier(){

        public float modifyProjectileSpread(float spread, GunData data) {
            return spread * 4.0f;
        }
    };
    public static final IGunModifier NAILGUN_SPLIT_BARREL = new IGunModifier(){
        public static final int AMMO_PER_SHOT = 4;

        public float modifyDamage(float damage, GunData data) {
            return damage * (float)13.getProjectileAmount(data);
        }

        public float modifyProjectileSpread(float spread, GunData data) {
            return spread * 8.0f;
        }

        public int modifyProjectileAmount(int amount, GunData data) {
            return 13.getProjectileAmount(data);
        }

        private static int getProjectileAmount(GunData data) {
            return Math.min(4, Gun.getAmmo((ItemStack)data.gun));
        }

        public int modifyAmmoPerShot(int ammoPerShot, GunData data) {
            return 4;
        }

        public int modifyFireRate(int rate, GunData data) {
            return (int)((double)rate * 2.5);
        }
    };
}

