/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.client.animators;

import com.nukateam.cgs.Gunsmithing;
import com.nukateam.cgs.common.faundation.registry.items.CgsAttachments;
import com.nukateam.cgs.common.utils.GunUtils;
import com.nukateam.ntgl.client.animators.WeaponAnimator;
import com.nukateam.ntgl.client.render.renderers.weapon.DynamicWeaponRenderer;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.util.util.WeaponStateHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class LauncherAnimator
extends WeaponAnimator {
    public static final String EMPTY = "empty";
    public static final String RELOAD_BALLISTA_MANUAL = "reload_ballista_manual";
    public static final String RELOAD_BALLISTA_AUTO = "reload_ballista_auto";
    public static final String RELOAD_AUTO = "reload_auto";
    public static final String SHOT_BALLISTA = "shot_ballista";
    public static final String HIDE_SIGHTS = "hide_sights";
    private int ammoCount;
    private boolean isBallista;
    private boolean isAutoLauncher;
    private boolean hasAir;
    private boolean hasScope;
    protected final AnimationController<WeaponAnimator> MISC_CONTROLLER = this.createController("misc_controller", this.animateMisc());

    public LauncherAnimator(ItemDisplayContext transformType, DynamicWeaponRenderer<WeaponAnimator> renderer) {
        super(transformType, renderer);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        super.registerControllers(controllerRegistrar);
        controllerRegistrar.add(new AnimationController[]{this.MISC_CONTROLLER});
    }

    protected void tickStart() {
        super.tickStart();
        Item magazineAttachment = WeaponStateHelper.getAttachmentItem((AttachmentType)AttachmentType.MAGAZINE, (ItemStack)this.getStack()).m_41720_();
        try {
            if (this.itemStack.m_41720_() instanceof WeaponItem) {
                WeaponData data = this.getGunData();
                this.ammoCount = WeaponStateHelper.getAmmoCount((WeaponData)data);
                this.isBallista = magazineAttachment == CgsAttachments.BALLISTAZOOKA.get();
                this.isAutoLauncher = magazineAttachment == CgsAttachments.AUTO_LAUNCHER.get();
                this.hasAir = GunUtils.hasAir(data);
                this.hasScope = WeaponStateHelper.hasAttachmentEquipped((ItemStack)this.getStack(), (AttachmentType)AttachmentType.SCOPE);
            }
        }
        catch (IllegalStateException e) {
            Gunsmithing.LOGGER.error(e.getMessage());
        }
    }

    protected RawAnimation getHoldAnimation(AnimationState<WeaponAnimator> event) {
        if (this.ammoCount == 0) {
            return this.playGunAnim(EMPTY, Animation.LoopType.LOOP);
        }
        return super.getHoldAnimation(event);
    }

    protected RawAnimation getShootingAnimation(AnimationState<WeaponAnimator> event) {
        if (this.isBallista) {
            RawAnimation animation = RawAnimation.begin().then(this.getGunAnim(SHOT_BALLISTA), Animation.LoopType.LOOP);
            this.animationHelper.syncAnimation(event, this.rate, new String[]{SHOT_BALLISTA});
            return animation;
        }
        return super.getShootingAnimation(event);
    }

    protected RawAnimation getDefaultReloadAnimation(AnimationState<WeaponAnimator> event) {
        if (this.isBallista) {
            if (this.hasAir) {
                RawAnimation animation = RawAnimation.begin().then(this.getGunAnim(RELOAD_BALLISTA_AUTO), Animation.LoopType.PLAY_ONCE);
                this.animationHelper.syncAnimation(event, this.reloadTime, new String[]{RELOAD_BALLISTA_AUTO});
                return animation;
            }
            RawAnimation animation = RawAnimation.begin().then(this.getGunAnim(RELOAD_BALLISTA_MANUAL), Animation.LoopType.PLAY_ONCE);
            this.animationHelper.syncAnimation(event, this.reloadTime, new String[]{RELOAD_BALLISTA_MANUAL});
            return animation;
        }
        if (this.isAutoLauncher) {
            RawAnimation animation = RawAnimation.begin().then(this.getGunAnim(RELOAD_AUTO), Animation.LoopType.PLAY_ONCE);
            this.animationHelper.syncAnimation(event, this.reloadTime, new String[]{RELOAD_AUTO});
            return animation;
        }
        return super.getDefaultReloadAnimation(event);
    }

    private AnimationController.AnimationStateHandler<WeaponAnimator> animateMisc() {
        return event -> {
            if (this.hasScope) {
                RawAnimation hideSights = RawAnimation.begin().then(this.getGunAnim(HIDE_SIGHTS), Animation.LoopType.LOOP);
                return event.setAndContinue(hideSights);
            }
            return PlayState.STOP;
        };
    }
}

