/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.client.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.nukateam.cgs.client.layers.LayerBase;
import com.nukateam.cgs.common.faundation.item.attachments.HammerHeadItem;
import com.nukateam.cgs.common.ntgl.CgsAttachmentTypes;
import com.nukateam.ntgl.client.animators.WeaponAnimator;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.util.util.ResourceUtils;
import com.nukateam.ntgl.common.util.util.WeaponStateHelper;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;

public class HammerHeadLayer<T extends WeaponAnimator>
extends LayerBase<T> {
    public static final String PATH = "textures/weapons/hammer/";
    public static HashMap<ResourceLocation, Boolean> textures = new HashMap();

    public HammerHeadLayer(GeoRenderer<T> entityRenderer) {
        super(entityRenderer);
    }

    protected boolean resourceExists(ResourceLocation location) {
        if (!textures.containsKey(location)) {
            textures.put(location, ResourceUtils.resourceExists((ResourceLocation)location));
        }
        return textures.get(location);
    }

    public void render(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        ResourceLocation texture = this.getHeadTexture(animatable);
        if (texture != null) {
            this.renderLayer(poseStack, animatable, bakedModel, bufferSource, partialTick, packedLight, texture);
        }
    }

    @Nullable
    private ResourceLocation getHeadTexture(T animatable) {
        ItemStack attachment = WeaponStateHelper.getAttachmentItem((AttachmentType)CgsAttachmentTypes.HEAD, (ItemStack)animatable.getStack());
        if (!attachment.m_41619_()) {
            HammerHeadItem head = (HammerHeadItem)attachment.m_41720_();
            String name = "hammer_" + head.getTier().toString().toLowerCase(Locale.ROOT) + ".png";
            return new ResourceLocation("cgs", PATH + name);
        }
        return null;
    }
}

