/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.ntgl;

import com.nukateam.cgs.common.faundation.item.attachments.HammerHeadItem;
import com.nukateam.cgs.common.faundation.item.guns.HammerItem;
import com.nukateam.cgs.common.faundation.registry.CgsSounds;
import com.nukateam.cgs.common.faundation.registry.items.CgsAmmo;
import com.nukateam.cgs.common.faundation.registry.items.CgsAttachments;
import com.nukateam.cgs.common.faundation.registry.items.CgsWeapons;
import com.nukateam.cgs.common.ntgl.CgsAmmoHolders;
import com.nukateam.cgs.common.ntgl.CgsProjectileTypes;
import com.nukateam.cgs.common.utils.GunUtils;
import com.nukateam.example.common.registery.WeaponModifiers;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.attachment.impl.Scope;
import com.nukateam.ntgl.common.data.config.weapon.ProjectileConfig;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.data.holders.FireMode;
import com.nukateam.ntgl.common.data.holders.GripType;
import com.nukateam.ntgl.common.data.holders.LoadingType;
import com.nukateam.ntgl.common.data.holders.WeaponAction;
import com.nukateam.ntgl.common.data.holders.WeaponMode;
import com.nukateam.ntgl.common.registry.AmmoHolders;
import com.nukateam.ntgl.common.util.interfaces.IWeaponModifier;
import com.nukateam.ntgl.common.util.util.FuelUtils;
import com.nukateam.ntgl.common.util.util.WeaponStateHelper;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AttachmentMods {
    public static final Scope LONG_SCOPE = Scope.builder().modifiers(new IWeaponModifier[]{WeaponModifiers.SLOWER_ADS}).aimFovModifier(0.25f).overlay().build();
    public static final ProjectileConfig FLAME_PROJECTILE = ProjectileConfig.Builder.create().setProjectileType(CgsProjectileTypes.FIREBALL).setDamage(1.0f).setProjectileLife(10).setProjectileSpeed(1.5f).setProjectileAmount(6).setSpread(15.0f).build();
    public static final ProjectileConfig SUPER_FLAME_PROJECTILE = ProjectileConfig.Builder.create().setProjectileType(CgsProjectileTypes.FIREBALL).setDamage(3.0f).setProjectileLife(10).setProjectileSpeed(2.5f).setProjectileAmount(8).setSpread(10.0f).build();
    public static final IWeaponModifier STEAM_ENGINE_MODIFIERS = new IWeaponModifier(){

        public ProjectileConfig modifyProjectile(ProjectileConfig value, WeaponData data) {
            if (data.weapon == null) {
                return value;
            }
            if (data.weapon.m_41720_() == CgsWeapons.BLAZEGUN.get()) {
                if (WeaponStateHelper.getCurrentAmmo((WeaponData)data) == CgsAmmoHolders.BLAZE_CAKE) {
                    return SUPER_FLAME_PROJECTILE;
                }
                return FLAME_PROJECTILE;
            }
            return value;
        }

        public int modifyFireRate(int rate, WeaponData data) {
            if (data.weapon == null) {
                return rate;
            }
            if (data.weapon.m_41720_() == CgsWeapons.NAILGUN.get()) {
                return rate * 2;
            }
            if (data.weapon.m_41720_() == CgsWeapons.GATLING.get() && FuelUtils.hasFuel((WeaponData)data)) {
                return rate / 2;
            }
            if (data.weapon.m_41720_() == CgsWeapons.BLAZEGUN.get()) {
                if (WeaponStateHelper.getCurrentAmmo((WeaponData)data) == CgsAmmoHolders.BLAZE_CAKE) {
                    return 1;
                }
                return 2;
            }
            return rate;
        }

        public int modifyFireDelay(int chargeTime, WeaponData data) {
            if (data.weapon == null) {
                return chargeTime;
            }
            if (data.weapon.m_41720_() == CgsWeapons.GATLING.get() && FuelUtils.hasFuel((WeaponData)data)) {
                return 0;
            }
            return super.modifyFireDelay(chargeTime, data);
        }

        public float modifyMovementSpeed(float value, WeaponData data) {
            if (data.weapon == null) {
                return value;
            }
            if (data.weapon.m_41720_() == CgsWeapons.GATLING.get()) {
                return value - 0.2f;
            }
            return super.modifyMovementSpeed(value, data);
        }

        public float modifyProjectileDamage(float damage, ResourceLocation ammo, WeaponData data) {
            if (data.weapon == null) {
                return damage;
            }
            if (data.weapon.m_41720_() == CgsWeapons.NAILGUN.get()) {
                return damage * 2.0f;
            }
            return damage;
        }

        public float recoilModifier(WeaponData data) {
            if (data.weapon != null && data.weapon.m_41720_() == CgsWeapons.NAILGUN.get()) {
                return 2.0f;
            }
            return super.recoilModifier(data);
        }

        public float kickModifier(WeaponData data) {
            if (data.weapon != null && data.weapon.m_41720_() == CgsWeapons.NAILGUN.get()) {
                return 2.0f;
            }
            return super.kickModifier(data);
        }

        public float modifyProjectileSpread(float spread, WeaponData data) {
            if (data.weapon == null) {
                return spread;
            }
            if (data.weapon.m_41720_() == CgsWeapons.GATLING.get() && FuelUtils.hasFuel((WeaponData)data)) {
                return spread + 8.0f;
            }
            return spread;
        }

        public Set<AmmoHolder> modifyFuelItems(Set<AmmoHolder> fuel, WeaponData data) {
            if (data.weapon == null) {
                return fuel;
            }
            if (data.weapon.m_41720_() == CgsWeapons.BLAZEGUN.get()) {
                return Set.of(AmmoHolders.WATER);
            }
            return Set.of(AmmoHolders.BURNABLE, AmmoHolders.WATER);
        }

        public GripType modifyGripType(GripType gripType, WeaponData data) {
            if (data != null && data.weapon != null) {
                if (data.weapon.m_41720_() == CgsWeapons.NAILGUN.get()) {
                    return GripType.TWO_HANDED;
                }
                if (data.weapon.m_41720_() == CgsWeapons.GATLING.get()) {
                    if (data.weapon.m_41720_() == CgsWeapons.GATLING.get()) {
                        return GripType.ONE_HANDED;
                    }
                    return gripType;
                }
            }
            return super.modifyGripType(gripType, data);
        }

        public ResourceLocation modifyFireSound(ResourceLocation sound, WeaponData data) {
            if (data.weapon != null && data.weapon.m_41720_() == CgsWeapons.NAILGUN.get()) {
                return ((SoundEvent)CgsSounds.NAILGUN_FIRE_STEAM.get()).m_11660_();
            }
            return super.modifyFireSound(sound, data);
        }

        public boolean modifyOneHanded(boolean value, WeaponData data) {
            if (data.weapon.m_41720_() == CgsWeapons.GATLING.get()) {
                return this.getGatlingOneHanded(data);
            }
            return value;
        }

        private boolean getGatlingOneHanded(WeaponData data) {
            if (data.wielder != null && data.weapon != null) {
                Item magazineItem = WeaponStateHelper.getAttachmentItem((AttachmentType)AttachmentType.MAGAZINE, (ItemStack)data.weapon).m_41720_();
                Item drumItem = (Item)CgsAttachments.GATLING_DRUM.get();
                boolean hasStrengthEffect = data.wielder.m_21023_(MobEffects.f_19600_);
                return magazineItem != drumItem && FuelUtils.hasFuel((WeaponData)data) && hasStrengthEffect;
            }
            return false;
        }
    };
    public static final IWeaponModifier GATLING_DRUM_MODIFIERS = new IWeaponModifier(){

        public int modifyMaxAmmo(int maxAmmo, WeaponData data) {
            return 300;
        }

        public float modifyProjectileSpread(float spread, WeaponData data) {
            return spread * 2.0f;
        }

        public float modifyMovementSpeed(float value, WeaponData data) {
            return value - 0.1f;
        }
    };
    public static final IWeaponModifier BAYONET_MODIFIERS = new IWeaponModifier(){

        public WeaponAction modifyWeaponAction(WeaponAction value, WeaponData data) {
            if (data.weaponMode == WeaponMode.ADDITIONAL) {
                return WeaponAction.MELEE;
            }
            return value;
        }

        public float modifyMeleeDamage(float value, WeaponData data) {
            return 10.0f;
        }

        public float modifyMeleeAngle(float value, WeaponData data) {
            if (data.weapon == null) {
                return value;
            }
            ItemStack barrel = WeaponStateHelper.getAttachmentItem((AttachmentType)AttachmentType.BARREL, (ItemStack)data.weapon);
            if (barrel.m_41720_() == CgsAttachments.FLINTLOCK_LONG_BARREL.get()) {
                return 20.0f;
            }
            return 120.0f;
        }

        public float modifyMeleeDistance(float value, WeaponData data) {
            if (data.weapon == null) {
                return value;
            }
            ItemStack barrel = WeaponStateHelper.getAttachmentItem((AttachmentType)AttachmentType.BARREL, (ItemStack)data.weapon);
            if (barrel.m_41720_() == CgsAttachments.FLINTLOCK_LONG_BARREL.get()) {
                return 5.0f;
            }
            return 3.0f;
        }

        public int modifyMeleeDelay(int time, WeaponData data) {
            return 5;
        }

        public int modifyMeleeCooldown(int time, WeaponData data) {
            return 8;
        }
    };
    public static final IWeaponModifier BELT_MODIFIERS = new IWeaponModifier(){

        public int modifyReloadTime(int reloadTime, WeaponData data) {
            return 20;
        }

        public int modifyMaxAmmo(int maxAmmo, WeaponData data) {
            return 12;
        }

        public double modifyAimDownSightSpeed(double speed, WeaponData data) {
            return speed * 0.75;
        }

        public LoadingType modifyLoadingType(LoadingType loadingType, WeaponData data) {
            return LoadingType.PER_CARTRIDGE;
        }
    };
    public static final IWeaponModifier AUTO_FIRE = new IWeaponModifier(){

        public int modifyFireDelay(int chargeTime, WeaponData data) {
            return 0;
        }

        public Set<FireMode> modifyFireModes(Set<FireMode> fireMode, WeaponData data) {
            return new LinkedHashSet<FireMode>(List.of(FireMode.AUTO, FireMode.SEMI_AUTO));
        }

        public float modifyProjectileSpread(float spread, WeaponData data) {
            return spread * 1.5f;
        }

        public int modifyFireRate(int rate, WeaponData data) {
            return rate / 2;
        }
    };
    public static final IWeaponModifier LONG_BARREL = new IWeaponModifier(){

        public GripType modifyGripType(GripType gripType, WeaponData data) {
            if (data.weapon != null && data.weapon.m_41720_() == CgsWeapons.REVOLVER.get()) {
                if (WeaponStateHelper.hasAttachmentEquipped((ItemStack)data.weapon, (AttachmentType)AttachmentType.STOCK)) {
                    return GripType.TWO_HANDED;
                }
                return gripType;
            }
            return GripType.TWO_HANDED;
        }

        public boolean modifyOneHanded(boolean value, WeaponData data) {
            return false;
        }

        public float modifyProjectileDamage(float damage, ResourceLocation ammo, WeaponData data) {
            return damage * 1.5f;
        }

        public double modifyAimDownSightSpeed(double speed, WeaponData data) {
            return speed * 0.95;
        }
    };
    public static final IWeaponModifier STOCK = new IWeaponModifier(){

        public float recoilModifier(WeaponData data) {
            return 0.1f;
        }

        public float kickModifier(WeaponData data) {
            return 0.1f;
        }

        public float modifyProjectileSpread(float spread, WeaponData data) {
            return spread * 0.25f;
        }

        public double modifyAimDownSightSpeed(double speed, WeaponData data) {
            return speed * (double)0.8f;
        }
    };
    public static final IWeaponModifier SHOTGUN_MODIFIER = new IWeaponModifier(){

        public int modifyFireRate(int rate, WeaponData data) {
            if (data.weapon == null) {
                return rate;
            }
            int cock = GunUtils.getCock(data.weapon);
            if (WeaponStateHelper.getFireMode((WeaponData)data) == FireMode.MULTI && cock == 2) {
                return 20;
            }
            if (cock == 1) {
                return 20;
            }
            return rate;
        }
    };
    public static final IWeaponModifier SHOTGUN_DRUM_MODIFIER = new IWeaponModifier(){

        public int modifyMaxAmmo(int maxAmmo, WeaponData data) {
            return 8;
        }

        public int modifyReloadTime(int reloadTime, WeaponData data) {
            return 80;
        }
    };
    public static final IWeaponModifier SHOTGUN_PUMP_MODIFIER = new IWeaponModifier(){

        public LoadingType modifyLoadingType(LoadingType loadingType, WeaponData data) {
            return LoadingType.PER_CARTRIDGE;
        }

        public int modifyMaxAmmo(int maxAmmo, WeaponData data) {
            return 10;
        }

        public int modifyReloadStart(int reloadTime, WeaponData data) {
            return 8;
        }

        public int modifyReloadTime(int reloadTime, WeaponData data) {
            return 12;
        }

        public int modifyReloadEnd(int reloadTime, WeaponData data) {
            return 20;
        }

        public GripType modifyGripType(GripType gripType, WeaponData data) {
            return GripType.TWO_HANDED;
        }

        public boolean modifyOneHanded(boolean value, WeaponData data) {
            return false;
        }
    };
    public static final IWeaponModifier SHOTGUN_LONG_BARREL = new IWeaponModifier(){

        public GripType modifyGripType(GripType gripType, WeaponData data) {
            return GripType.TWO_HANDED;
        }

        public boolean modifyOneHanded(boolean value, WeaponData data) {
            return false;
        }

        public float modifyProjectileSpread(float spread, WeaponData data) {
            return spread * 0.5f;
        }
    };
    public static final IWeaponModifier SHOTGUN_SPREAD_BARREL = new IWeaponModifier(){

        public float modifyProjectileDamage(float damage, ResourceLocation ammo, WeaponData data) {
            return damage * 1.5f;
        }

        public float modifyProjectileSpread(float spread, WeaponData data) {
            return spread * 2.0f;
        }
    };
    public static final IWeaponModifier NAILGUN_SPLIT_BARREL = new IWeaponModifier(){
        public static final int AMMO_PER_SHOT = 4;

        public float modifyProjectileDamage(float damage, ResourceLocation ammo, WeaponData data) {
            return damage * (float)13.getProjectileAmount(data);
        }

        public float modifyProjectileSpread(float spread, WeaponData data) {
            return spread * 8.0f;
        }

        public int modifyProjectileAmount(int amount, WeaponData data) {
            return 13.getProjectileAmount(data);
        }

        private static int getProjectileAmount(WeaponData data) {
            return Math.min(4, WeaponStateHelper.getAmmoCount((WeaponData)data));
        }

        public int modifyAmmoPerShot(int ammoPerShot, WeaponData data) {
            return 4;
        }

        public int modifyFireRate(int rate, WeaponData data) {
            return (int)((double)rate * 2.5);
        }
    };
    public static final IWeaponModifier RECIEVER = new IWeaponModifier(){

        public int modifyMaxAmmo(int maxAmmo, WeaponData data) {
            return 6;
        }

        public int modifyAmmoPerShot(int ammoPerShot, WeaponData data) {
            return 1;
        }

        public float modifyMeleeDamage(float damage, WeaponData data) {
            WeaponStateHelper.getAmmoCount((WeaponData)data);
            return damage * 2.0f;
        }

        public Set<AmmoHolder> modifyAmmoItems(Set<AmmoHolder> item, WeaponData data) {
            return Set.of(AmmoHolder.getType((ResourceLocation)CgsAmmo.SHOTGUN_ROUND_BLANK.getId()));
        }
    };
    public static final IWeaponModifier HAMMER_HEAD = new HeadModifier(){

        public int modifyMeleeMaxTargets(int value, WeaponData data) {
            return 6;
        }

        public float modifyMeleeAngle(float value, WeaponData data) {
            return 80.0f;
        }
    };
    public static final IWeaponModifier AXE_HEAD = new HeadModifier(){

        public int modifyMeleeMaxTargets(int value, WeaponData data) {
            return 1;
        }

        @Override
        public float modifyMeleeDamage(float damage, WeaponData data) {
            return super.modifyMeleeDamage(damage, data) + 4.0f;
        }
    };
    public static final IWeaponModifier BALLISTAZOOKA = new IWeaponModifier(){

        public Set<FireMode> modifyFireModes(Set<FireMode> fireMode, WeaponData data) {
            return new LinkedHashSet<FireMode>(List.of(FireMode.SEMI_AUTO));
        }

        public int modifyMaxAmmo(int maxAmmo, WeaponData data) {
            return 1;
        }

        public int modifyFireRate(int rate, WeaponData data) {
            return 15;
        }

        public float modifyProjectileSpread(float spread, WeaponData data) {
            return 1.0f;
        }

        public int modifyReloadTime(int reloadTime, WeaponData data) {
            if (FuelUtils.hasFuel((WeaponData)data)) {
                return 80;
            }
            return 140;
        }

        public Set<AmmoHolder> modifyFuelItems(Set<AmmoHolder> secondaryAmmo, WeaponData data) {
            return Set.of(CgsAmmoHolders.AIR);
        }

        public Set<AmmoHolder> modifyAmmoItems(Set<AmmoHolder> item, WeaponData data) {
            return Set.of(AmmoHolder.getType((ResourceLocation)CgsAmmo.SPEAR.getId()));
        }

        public ResourceLocation modifyFireSound(ResourceLocation sound, WeaponData data) {
            return CgsSounds.BALLISTA_FIRE.getId();
        }

        public boolean modifyAutoReloading(boolean autoReload, WeaponData data) {
            return true;
        }
    };
    public static final IWeaponModifier AUTO_LAUNCHER = new IWeaponModifier(){

        public Set<FireMode> modifyFireModes(Set<FireMode> fireMode, WeaponData data) {
            return new LinkedHashSet<FireMode>(List.of(FireMode.AUTO));
        }

        public int modifyFuelAmountPerUse(ResourceLocation ammo, int value, WeaponData data) {
            if (ammo.equals((Object)CgsAmmoHolders.AIR.getId())) {
                return 1;
            }
            return value;
        }

        public int modifyMaxAmmo(int maxAmmo, WeaponData data) {
            return 30;
        }

        public Set<AmmoHolder> modifyAmmoItems(Set<AmmoHolder> item, WeaponData data) {
            return Set.of(AmmoHolder.getType((ResourceLocation)CgsAmmo.SMALL_ROCKET.getId()));
        }

        public int modifyFireRate(int rate, WeaponData data) {
            return 2;
        }

        public int modifyReloadTime(int reloadTime, WeaponData data) {
            return 100;
        }

        public Set<AmmoHolder> modifyFuelItems(Set<AmmoHolder> secondaryAmmo, WeaponData data) {
            return Set.of(CgsAmmoHolders.AIR);
        }
    };
    public static final IWeaponModifier BIG_BAYONET = new IWeaponModifier(){

        public WeaponAction modifyWeaponAction(WeaponAction value, WeaponData data) {
            if (data.weaponMode == WeaponMode.ADDITIONAL) {
                return WeaponAction.MELEE;
            }
            return value;
        }

        public float modifyMeleeDamage(float value, WeaponData data) {
            return 12.0f;
        }
    };

    private static float getHeadMeleeDamage(float damage, ItemStack attachment) {
        Item item = attachment.m_41720_();
        if (item instanceof HammerHeadItem) {
            HammerHeadItem headItem = (HammerHeadItem)item;
            return damage + 2.0f + headItem.getTier().m_6631_() * 2.0f;
        }
        return damage;
    }

    private static class HeadModifier
    implements IWeaponModifier {
        private HeadModifier() {
        }

        public WeaponAction modifyWeaponAction(WeaponAction value, WeaponData data) {
            if (data.weaponMode == WeaponMode.SECONDARY && HammerItem.isPowered(data)) {
                return WeaponAction.MELEE;
            }
            return super.modifyWeaponAction(value, data);
        }

        public float modifyMeleeDamage(float damage, WeaponData data) {
            if (data.weapon != null) {
                damage = AttachmentMods.getHeadMeleeDamage(damage, data.attachment);
                if (data.weaponMode == WeaponMode.SECONDARY && HammerItem.isPowered(data)) {
                    damage += 6.0f;
                }
                return damage;
            }
            return 1.0f;
        }
    }
}

