/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.datagen.providers;

import com.nukateam.cgs.common.datagen.DataGenConfig;
import com.nukateam.cgs.common.datagen.DataGenUtils;
import com.nukateam.cgs.common.datagen.annotations.BlockStateGen;
import com.nukateam.cgs.common.faundation.registry.CgsBlocks;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class CgsBlockStateProvider
extends BlockStateProvider {
    public CgsBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "cgs", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (Class clazz : DataGenConfig.dataGenClasses) {
            DataGenUtils.handleFields(clazz, BlockStateGen.class, this::handleDataGenField);
        }
        this.layeredBlockWithItem(CgsBlocks.GUANO_BLOCK);
    }

    private void handleDataGenField(Object obj, BlockStateGen annotation) {
        RegistryObject registryObject;
        if (obj instanceof RegistryObject && (registryObject = (RegistryObject)obj).get() instanceof Block) {
            this.blockWithItem((RegistryObject<Block>)registryObject);
        }
    }

    private void blockWithItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }

    private void simpleBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlock((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }

    private void layeredBlockWithItem(RegistryObject<Block> blockRegistryObject) {
        Block block = (Block)blockRegistryObject.get();
        String blockName = blockRegistryObject.getId().m_135815_();
        ModelFile[] layerModels = new ModelFile[8];
        for (int i = 0; i < 7; ++i) {
            int layers = i + 1;
            String heightName = String.valueOf(layers * 2);
            layerModels[i] = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName + "_height" + heightName, "block/snow_height" + heightName)).texture("texture", this.blockTexture(block))).texture("particle", this.blockTexture(block));
        }
        layerModels[7] = this.models().cubeAll(blockName, this.blockTexture(block));
        this.getVariantBuilder(block).forAllStates(state -> {
            int layers = (Integer)state.m_61143_((Property)BlockStateProperties.f_61417_);
            ModelFile model = layerModels[layers - 1];
            return ConfiguredModel.builder().modelFile(model).build();
        });
    }

    private boolean hasLayersProperty(Block block) {
        return block.m_49965_().m_61092_().stream().anyMatch(property -> property == BlockStateProperties.f_61417_);
    }
}

