/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.faundation.entity;

import com.nukateam.cgs.common.faundation.entity.AnimatedProjectile;
import com.nukateam.cgs.common.ntgl.CgsAmmo;
import com.nukateam.cgs.common.ntgl.CgsAttachmentTypes;
import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.foundation.entity.ProjectileEntity;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import java.util.function.Predicate;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoulFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class BlazeProjectile
extends ProjectileEntity
implements ItemSupplier,
AnimatedProjectile {
    protected final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean isSuperHeated;
    private boolean isStrong;

    public BlazeProjectile(EntityType<? extends ProjectileEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public BlazeProjectile(EntityType<? extends ProjectileEntity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, WeaponItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
        this.isSuperHeated = GunStateHelper.getCurrentAmmo((GunData)new GunData(weapon, shooter)) == CgsAmmo.BLAZE_CAKE;
        this.isStrong = !GunStateHelper.hasAttachmentEquipped((ItemStack)weapon, (AttachmentType)CgsAttachmentTypes.ENGINE);
    }

    protected Predicate<BlockState> getBlockFilter() {
        return value -> false;
    }

    public void m_8119_() {
        if (!this.isStrong && this.m_20069_()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        super.m_8119_();
    }

    @NotNull
    public ItemStack m_7846_() {
        if (this.isStrong) {
            return new ItemStack((ItemLike)Items.f_42613_);
        }
        return ItemStack.f_41583_;
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("isSuperHeated", this.isSuperHeated);
        compound.m_128379_("isStrong", this.isStrong);
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.isSuperHeated = compound.m_128471_("isSuperHeated");
        this.isStrong = compound.m_128471_("isStrong");
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeBoolean(this.isSuperHeated);
        buffer.writeBoolean(this.isStrong);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        super.readSpawnData(buffer);
        this.isSuperHeated = buffer.readBoolean();
        this.isStrong = buffer.readBoolean();
    }

    protected void onProjectileTick() {
        if (this.m_9236_().f_46443_) {
            if (this.isSuperHeated) {
                for (int i = 5; i > 0; --i) {
                    this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123745_, true, this.m_20185_() - this.m_20184_().m_7096_() / (double)i, this.m_20186_() - this.m_20184_().m_7098_() / (double)i, this.m_20189_() - this.m_20184_().m_7094_() / (double)i, 0.0, 0.0, 0.0);
                }
            } else {
                for (int i = 5; i > 0; --i) {
                    this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123744_, true, this.m_20185_() - this.m_20184_().m_7096_() / (double)i, this.m_20186_() - this.m_20184_().m_7098_() / (double)i, this.m_20189_() - this.m_20184_().m_7094_() / (double)i, 0.0, 0.0, 0.0);
                }
            }
            if (this.m_9236_().f_46441_.m_188503_(2) == 0) {
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        super.onHitEntity(entity, hitVec, startVec, endVec, headshot);
        if (!this.m_9236_().f_46443_) {
            LivingEntity owner = this.getShooter();
            entity.m_20254_(5);
            this.m_19970_(owner, entity);
        }
    }

    protected void onHitBlock(BlockState blockstate, BlockPos blockpos, Direction face, double x, double y, double z) {
        LivingEntity entity;
        super.onHitBlock(blockstate, blockpos, face, x, y, z);
        if (!(this.m_9236_().f_46443_ || (entity = this.getShooter()) instanceof Mob && !ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)entity))) {
            blockpos = blockpos.m_121945_(face);
            if (this.m_9236_().m_46859_(blockpos)) {
                this.m_9236_().m_46597_(blockpos, SoulFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)blockpos));
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

