/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.handlers;

import com.nukateam.cgs.common.faundation.registry.items.AttachmentItems;
import com.nukateam.cgs.common.faundation.registry.items.CgsWeapons;
import com.nukateam.cgs.common.ntgl.CgsAmmo;
import com.nukateam.cgs.common.utils.GunUtils;
import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.AmmoHolders;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.event.GunFireEvent;
import com.nukateam.ntgl.common.event.GunProjectileHitEvent;
import com.nukateam.ntgl.common.event.GunReloadEvent;
import com.nukateam.ntgl.common.util.util.FuelUtils;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.armor.BacktankBlockEntity;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cgs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GunEventHandler {
    @SubscribeEvent
    public static void preShoot(GunFireEvent.Pre event) {
        boolean hasExtendoGrip;
        LivingEntity shooter = event.getEntity();
        ItemStack gun = shooter.m_21120_(event.getHand());
        GunData gunData = new GunData(gun, shooter);
        boolean bl = hasExtendoGrip = shooter.m_21206_().m_41720_() == AllItems.EXTENDO_GRIP.get();
        if (hasExtendoGrip && !GunModifierHelper.isOneHanded((GunData)gunData)) {
            event.setCanceled(true);
        }
        if (gun.m_41720_() == CgsWeapons.LAUNCHER.get() && GunStateHelper.getAttachmentItem((AttachmentType)AttachmentType.MAGAZINE, (ItemStack)gun).m_41720_() == AttachmentItems.BALLISTAZOOKA.get()) {
            return;
        }
        if (GunEventHandler.isUsesFuel(gunData, CgsAmmo.AIR) && !GunUtils.hasAir(gunData)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void postShoot(GunFireEvent.Post event) {
        LivingEntity shooter = event.getEntity();
        ItemStack gun = event.getStack();
        GunData data = new GunData(gun, shooter);
        Set fuel = GunModifierHelper.getAllFuel((GunData)data);
        if (fuel.contains(AmmoHolders.BURNABLE)) {
            FuelUtils.addFuel((GunData)data, (AmmoHolder)AmmoHolders.BURNABLE, (int)-1);
        }
        if (fuel.contains(AmmoHolders.WATER)) {
            FuelUtils.addFuel((GunData)data, (AmmoHolder)AmmoHolders.WATER, (int)-5);
        }
        if (fuel.contains(CgsAmmo.AIR)) {
            GunEventHandler.consumeAir(data);
        }
        if (gun.m_41720_() == CgsWeapons.SHOTGUN.get()) {
            GunEventHandler.checkCock(data);
        }
    }

    @SubscribeEvent
    public static void postReload(GunReloadEvent.Post event) {
        ItemStack gun = event.getStack();
        Player shooter = event.getEntity();
        GunData data = new GunData(gun, (LivingEntity)shooter);
        if (!event.getEntity().m_9236_().f_46443_) {
            if (gun.m_41720_() == CgsWeapons.SHOTGUN.get()) {
                GunEventHandler.checkCock(data);
            }
            if (gun.m_41720_() == CgsWeapons.LAUNCHER.get()) {
                GunEventHandler.consumeAir(data);
            }
        }
    }

    private static void checkCock(GunData data) {
        int ammoCount = GunStateHelper.getAmmoCount((GunData)data);
        boolean isEven = GunStateHelper.getAmmoCount((GunData)data) % 2 == 0;
        int id = 0;
        if (ammoCount != 0) {
            id = isEven ? 2 : 1;
        }
        GunUtils.setCock(data.gun, id);
    }

    public static boolean consumeAir(GunData data) {
        Player player;
        int amount = GunModifierHelper.getFuelAmountPerUse((ResourceLocation)CgsAmmo.AIR.getId(), (GunData)data);
        if (amount == 0) {
            return false;
        }
        LivingEntity livingEntity = data.shooter;
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_7500_()) {
            return true;
        }
        List backtanks = BacktankUtil.getAllWithAir((LivingEntity)data.shooter);
        if (!backtanks.isEmpty()) {
            BacktankUtil.consumeAir((LivingEntity)data.shooter, (ItemStack)((ItemStack)backtanks.get(0)), (float)amount);
        } else {
            FuelUtils.consumeFuel((AmmoHolder)CgsAmmo.AIR, (GunData)data);
        }
        return true;
    }

    public static boolean isUsesFuel(GunData data, AmmoHolder ammo) {
        return GunModifierHelper.getAllFuel((GunData)data).stream().anyMatch(i -> i.getId().equals((Object)ammo.getId()));
    }

    public static boolean hasAirInTank(GunData data) {
        Player player;
        LivingEntity livingEntity = data.shooter;
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_7500_()) {
            return true;
        }
        List backtanks = BacktankUtil.getAllWithAir((LivingEntity)data.shooter);
        if (backtanks.isEmpty()) {
            return false;
        }
        int cost = GunModifierHelper.getFuelAmountPerUse((ResourceLocation)CgsAmmo.AIR.getId(), (GunData)data);
        return BacktankUtil.getAir((ItemStack)((ItemStack)backtanks.get(0))) >= (float)cost;
    }

    @SubscribeEvent
    public static void onHit(GunProjectileHitEvent event) {
        LivingEntity shooter = event.getProjectile().getShooter();
        HitResult hitResult = event.getRayTrace();
        Level level = shooter.m_9236_();
        Vec3 pos = hitResult.m_82450_();
        HitResult.Type type = hitResult.m_6662_();
        if (type == HitResult.Type.BLOCK) {
            int max;
            BacktankBlockEntity tankEntity;
            int airLevel;
            BlockPos blockPos = new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_);
            BlockState blockState = level.m_8055_(blockPos);
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockState.m_60734_() == AllBlocks.COPPER_BACKTANK.get() && blockEntity instanceof BacktankBlockEntity && (airLevel = (tankEntity = (BacktankBlockEntity)blockEntity).getAirLevel()) >= (max = BacktankUtil.maxAir((int)0)) / 3) {
                GunEventHandler.explodeOnHit(level, blockPos);
            }
        }
    }

    public static void explodeOnHit(Level level, BlockPos pos) {
        if (!level.f_46443_) {
            level.m_46961_(pos, false);
            level.m_254849_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 6.0f, Level.ExplosionInteraction.NONE);
        }
    }
}

