/*
 * Decompiled with CFR 0.152.
 */
package com.luigi.phonkeditmod;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class CustomResourceManager {
    private static final Path CUSTOM_IMAGES_DIR = FabricLoader.getInstance().getGameDir().resolve("phonk-edit-mod").resolve("custom_images");
    private static final List<class_2960> customImages = new ArrayList<class_2960>();
    private static int lastImageErrors = 0;
    private static int lastAudioErrors = 0;

    public static void initDirectories() {
        try {
            Files.createDirectories(CUSTOM_IMAGES_DIR, new FileAttribute[0]);
            CustomResourceManager.createReadmeFile(CUSTOM_IMAGES_DIR, "Place your custom skull/meme images here (.png format).\nRecommended size: 512x512 pixels (or any square resolution)\nAfter adding files, click 'Reload Custom Files' in the mod config menu (Press O).");
        }
        catch (IOException e) {
            System.err.println("Erro ao criar diret\u00f3rio de imagens customizadas: " + e.getMessage());
        }
    }

    private static void createReadmeFile(Path directory, String content) {
        Path readmePath = directory.resolve("README.txt");
        if (!Files.exists(readmePath, new LinkOption[0])) {
            try {
                Files.writeString(readmePath, (CharSequence)content, new OpenOption[0]);
            }
            catch (IOException e) {
                System.err.println("Erro ao criar README: " + e.getMessage());
            }
        }
    }

    public static void loadCustomResources() {
        System.out.println("[Phonk Edit Mod] Carregando imagens customizadas...");
        CustomResourceManager.loadCustomImages();
        System.out.println("[Phonk Edit Mod] Imagens customizadas carregadas!");
    }

    private static void loadCustomImages() {
        class_310 client = class_310.method_1551();
        if (client == null || client.method_1531() == null) {
            System.err.println("[Phonk Edit Mod] TextureManager n\u00e3o est\u00e1 dispon\u00edvel ainda. Pulando carregamento de imagens.");
            return;
        }
        for (class_2960 id : customImages) {
            try {
                client.method_1531().method_4615(id);
            }
            catch (Exception e) {
                System.err.println("[Phonk Edit Mod] Erro ao destruir textura: " + e.getMessage());
            }
        }
        customImages.clear();
        lastImageErrors = 0;
        try {
            if (!Files.exists(CUSTOM_IMAGES_DIR, new LinkOption[0])) {
                return;
            }
            List allFiles = Files.list(CUSTOM_IMAGES_DIR).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> !path.getFileName().toString().equals("README.txt")).collect(Collectors.toList());
            List pngFiles = allFiles.stream().filter(path -> path.toString().toLowerCase().endsWith(".png")).collect(Collectors.toList());
            int nonPngFiles = allFiles.size() - pngFiles.size();
            if (nonPngFiles > 0) {
                lastImageErrors = nonPngFiles;
                System.err.println("[Phonk Edit Mod] Encontrados " + nonPngFiles + " arquivo(s) em formato inv\u00e1lido (s\u00f3 PNG \u00e9 suportado!)");
            }
            for (int i = 0; i < pngFiles.size(); ++i) {
                Path imageFile = (Path)pngFiles.get(i);
                try {
                    class_2960 imageId = class_2960.method_60655((String)"phonk-edit-mod", (String)("custom_image_" + i));
                    BufferedImage bufferedImage = ImageIO.read(imageFile.toFile());
                    if (bufferedImage == null) {
                        System.err.println("[Phonk Edit Mod] Falha ao ler imagem: " + String.valueOf(imageFile.getFileName()));
                        ++lastImageErrors;
                        continue;
                    }
                    class_1011 nativeImage = CustomResourceManager.convertToNativeImage(bufferedImage);
                    client.method_1531().method_4616(imageId, (class_1044)new class_1043(nativeImage));
                    customImages.add(imageId);
                    System.out.println("[Phonk Edit Mod] Carregada imagem customizada: " + String.valueOf(imageFile.getFileName()));
                    continue;
                }
                catch (Exception e) {
                    System.err.println("[Phonk Edit Mod] Erro ao carregar imagem " + String.valueOf(imageFile.getFileName()) + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            System.err.println("[Phonk Edit Mod] Erro ao listar imagens customizadas: " + e.getMessage());
        }
    }

    private static class_1011 convertToNativeImage(BufferedImage bufferedImage) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        class_1011 nativeImage = new class_1011(width, height, false);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb = bufferedImage.getRGB(x, y);
                int a = rgb >> 24 & 0xFF;
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                int abgr = a << 24 | b << 16 | g << 8 | r;
                nativeImage.method_4305(x, y, abgr);
            }
        }
        return nativeImage;
    }

    public static List<class_2960> getCustomImages() {
        return customImages;
    }

    public static int getLastImageErrors() {
        return lastImageErrors;
    }

    public static int getLastAudioErrors() {
        return lastAudioErrors;
    }

    public static int detectInvalidAudioFiles() {
        lastAudioErrors = 0;
        try {
            Path minecraftDir = Paths.get(System.getProperty("user.dir"), new String[0]);
            Path resourcepacksDir = minecraftDir.resolve("resourcepacks");
            Path tutorialPackDir = resourcepacksDir.resolve("PhonkEdit-CustomSongs");
            Path customSoundsDir = tutorialPackDir.resolve("assets/phonk-edit-mod/sounds/custom");
            if (!Files.exists(customSoundsDir, new LinkOption[0])) {
                return 0;
            }
            List allFiles = Files.list(customSoundsDir).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> !path.getFileName().toString().equals("PLACE_OGG_FILES_HERE.txt")).filter(path -> !path.getFileName().toString().equals(".gitkeep")).collect(Collectors.toList());
            long nonOggFiles = allFiles.stream().filter(path -> !path.toString().toLowerCase().endsWith(".ogg")).count();
            lastAudioErrors = (int)nonOggFiles;
            if (nonOggFiles > 0L) {
                System.err.println("[Phonk Edit Mod] Encontrados " + nonOggFiles + " arquivo(s) de \u00e1udio em formato inv\u00e1lido (s\u00f3 OGG \u00e9 suportado!)");
                allFiles.stream().filter(path -> !path.toString().toLowerCase().endsWith(".ogg")).forEach(path -> System.err.println("[Phonk Edit Mod]   - " + String.valueOf(path.getFileName()) + " (formato inv\u00e1lido)"));
            }
        }
        catch (IOException e) {
            System.err.println("[Phonk Edit Mod] Erro ao verificar arquivos de \u00e1udio: " + e.getMessage());
        }
        return lastAudioErrors;
    }

    public static Path getCustomImagesDirectory() {
        return CUSTOM_IMAGES_DIR;
    }
}

