/*
 * Decompiled with CFR 0.152.
 */
package com.luigi.phonkeditmod;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3414;

@Environment(value=EnvType.CLIENT)
public class CustomSoundDetector {
    private static final List<class_3414> customSounds = new ArrayList<class_3414>();
    private static final List<String> customSoundNames = new ArrayList<String>();
    private static int previousSoundCount = 0;

    public static boolean detectCustomSounds() {
        int oldCount = previousSoundCount;
        customSounds.clear();
        customSoundNames.clear();
        class_310 client = class_310.method_1551();
        if (client == null) {
            return false;
        }
        class_3300 resourceManager = client.method_1478();
        try {
            class_2960 soundsJsonId = class_2960.method_60655((String)"phonk-edit-mod", (String)"sounds.json");
            Optional resourceOpt = resourceManager.method_14486(soundsJsonId);
            if (resourceOpt.isEmpty()) {
                System.out.println("[Phonk Edit Mod] Nenhum sounds.json encontrado");
                previousSoundCount = 0;
                return false;
            }
            class_3298 resource = (class_3298)resourceOpt.get();
            try (InputStreamReader reader = new InputStreamReader(resource.method_14482());){
                JsonObject soundsJson = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                for (String key : soundsJson.keySet()) {
                    if (!key.startsWith("custom/")) continue;
                    class_2960 soundId = class_2960.method_60655((String)"phonk-edit-mod", (String)key);
                    class_3414 soundEvent = class_3414.method_47908((class_2960)soundId);
                    customSounds.add(soundEvent);
                    customSoundNames.add(key);
                    System.out.println("[Phonk Edit Mod] Detectado som customizado via resource pack: " + key);
                }
            }
            if (!customSounds.isEmpty()) {
                System.out.println("[Phonk Edit Mod] Total de sons customizados detectados: " + customSounds.size());
            } else {
                System.out.println("[Phonk Edit Mod] Nenhum som customizado encontrado (procure por chaves 'custom/*' no sounds.json)");
            }
            boolean foundNewSounds = customSounds.size() > oldCount && oldCount >= 0;
            System.out.println("[Phonk Edit Mod] DEBUG - oldCount: " + oldCount + ", newCount: " + customSounds.size() + ", foundNewSounds: " + foundNewSounds);
            previousSoundCount = customSounds.size();
            return foundNewSounds;
        }
        catch (Exception e) {
            System.err.println("[Phonk Edit Mod] Erro ao detectar sons customizados: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static List<class_3414> getCustomSounds() {
        return new ArrayList<class_3414>(customSounds);
    }

    public static List<String> getCustomSoundNames() {
        return new ArrayList<String>(customSoundNames);
    }

    public static boolean hasCustomSounds() {
        return !customSounds.isEmpty();
    }

    public static int getCustomSoundCount() {
        return customSounds.size();
    }
}

