/*
 * Decompiled with CFR 0.152.
 */
package com.luigi.phonkeditmod;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "phonk-edit-mod.json");
    public int minSegundosEntreEfeitos = 30;
    public int maxSegundosEntreEfeitos = 60;
    public int duracaoEfeitoSegundos = 3;
    public int delayAcaoMs = 150;
    public float chanceAtivarPorAcao = 0.3f;
    public boolean habilitarTimerAleatorio = true;
    public boolean timerIgnoraChance = false;
    public boolean habilitarTriggerAtaque = true;
    public boolean habilitarTriggerQuebrarBloco = true;
    public boolean habilitarTriggerUsarBloco = true;
    public boolean habilitarTriggerUsarItem = true;
    public boolean habilitarTriggerTomarDano = true;
    public float pitchMinimo = 0.2f;
    public float pitchMaximo = 2.0f;
    public float volumeMusica = 1.0f;
    public ResourceMode audioMode = ResourceMode.MOD_ONLY;
    public ResourceMode imageMode = ResourceMode.MOD_ONLY;
    public int tamanhoIcone = 48;
    public boolean habilitarGrayscale = true;
    public boolean habilitarBlur = true;
    public boolean habilitarZoom = true;
    public boolean habilitarShake = true;
    public boolean habilitarBarrasPretas = true;
    public boolean habilitarTextoMeme = true;
    public boolean habilitarIconeCaveira = true;
    public float intensidadeZoom = 1.0f;
    public float intensidadeBlur = 1.0f;
    public float intensidadeShake = 1.0f;

    public static ModConfig load() {
        ModConfig modConfig;
        if (!CONFIG_FILE.exists()) {
            ModConfig config = new ModConfig();
            config.save();
            return config;
        }
        FileReader reader = new FileReader(CONFIG_FILE);
        try {
            modConfig = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("Erro ao carregar config do Phonk Edit Mod: " + e.getMessage());
                return new ModConfig();
            }
        }
        reader.close();
        return modConfig;
    }

    public void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("Erro ao salvar config do Phonk Edit Mod: " + e.getMessage());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum ResourceMode {
        MOD_ONLY("Mod Only"),
        MIX("Mix"),
        CUSTOM_ONLY("Custom Only");

        private final String displayName;

        private ResourceMode(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public ResourceMode next() {
            ResourceMode[] values = ResourceMode.values();
            return values[(this.ordinal() + 1) % values.length];
        }
    }
}

