/*
 * Decompiled with CFR 0.152.
 */
package com.luigi.phonkeditmod;

import com.luigi.phonkeditmod.ConfigScreen;
import com.luigi.phonkeditmod.CustomResourceManager;
import com.luigi.phonkeditmod.CustomSoundDetector;
import com.luigi.phonkeditmod.InvisiblePauseScreen;
import com.luigi.phonkeditmod.ModConfig;
import com.luigi.phonkeditmod.NotificationToast;
import com.luigi.phonkeditmod.TutorialResourcePackGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3414;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.ladysnake.satin.api.managed.ManagedShaderEffect;
import org.ladysnake.satin.api.managed.ShaderEffectManager;

@Environment(value=EnvType.CLIENT)
public class PhonkEditModClient
implements ClientModInitializer {
    private static final int MEME_TEXTURE_SIZE = 512;
    private static ModConfig config;
    private static class_304 configKey;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final class_2960[] MEME_IMAGES;
    private static final class_3414[] MEME_SOUNDS;
    private static final String[] MEME_TEXTS;
    private static PhonkEditModClient instance;
    private final Random random = new Random();
    private boolean isMemeActive = false;
    private int ticksParaProximoMeme = -1;
    private int ticksMemeAtivo = 0;
    private class_2960 imagemMemeAtual;
    private class_1113 somMemeAtual = null;
    private float vidaAnterior = -1.0f;
    private String textoMemeAtual;
    private boolean customResourcesLoaded = false;
    private static boolean applyCameraEffects;
    private static float currentZoom;
    private static float targetZoom;
    private static float shakeIntensity;
    private static float blurIntensity;
    private static float effectProgress;
    private static float currentPitch;
    private static float beatProgress;
    private static int ticksPerBeat;
    private static final ManagedShaderEffect GRAYSCALE_SHADER;
    private static final ManagedShaderEffect RADIAL_BLUR_SHADER;
    private static final ManagedShaderEffect PASSTHROUGH_SHADER;

    public void onInitializeClient() {
        instance = this;
        config = ModConfig.load();
        TutorialResourcePackGenerator.generateIfNeeded();
        CustomResourceManager.initDirectories();
        configKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.phonk-edit-mod.config", class_3675.class_307.field_1668, 79, "category.phonk-edit-mod"));
        this.registerTickTimer();
        this.registerHudRenderer();
        this.registerActionTriggers();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return class_2960.method_60655((String)"phonk-edit-mod", (String)"resource_reload");
            }

            public void method_14491(class_3300 manager) {
                System.out.println("[Phonk Edit Mod] Resources recarregados! Re-detectando sons customizados...");
                int audioErrors = CustomResourceManager.detectInvalidAudioFiles();
                CustomSoundDetector.detectCustomSounds();
                CustomResourceManager.loadCustomResources();
                class_310 client = class_310.method_1551();
                if (client != null && client.field_1724 != null) {
                    int totalSoundsInJson = CustomSoundDetector.getCustomSoundCount();
                    int validAudioCount = Math.max(0, totalSoundsInJson - audioErrors);
                    int imageCount = CustomResourceManager.getCustomImages().size();
                    int imageErrors = CustomResourceManager.getLastImageErrors();
                    PhonkEditModClient.this.showResourceNotifications(validAudioCount, audioErrors, imageCount, imageErrors);
                }
            }
        });
    }

    private void registerTickTimer() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!this.customResourcesLoaded && client.field_1724 != null) {
                try {
                    TutorialResourcePackGenerator.enablePackAutomatically();
                    CustomResourceManager.loadCustomResources();
                    CustomSoundDetector.detectCustomSounds();
                    this.customResourcesLoaded = true;
                    System.out.println("[Phonk Edit Mod] Recursos customizados carregados com sucesso!");
                }
                catch (Exception e) {
                    System.err.println("[Phonk Edit Mod] Erro ao carregar recursos customizados: " + e.getMessage());
                    e.printStackTrace();
                    this.customResourcesLoaded = true;
                }
            }
            if (configKey.method_1436()) {
                client.method_1507((class_437)new ConfigScreen(client.field_1755, config));
            }
            if (client.field_1724 == null) {
                this.ticksParaProximoMeme = -1;
                this.pararMeme(client);
                this.vidaAnterior = -1.0f;
                return;
            }
            float vidaAtual = client.field_1724.method_6032();
            if (this.vidaAnterior > 0.0f && vidaAtual < this.vidaAnterior && PhonkEditModClient.config.habilitarTriggerTomarDano) {
                this.tentarAtivarMemePorAcaoComDelay();
            }
            this.vidaAnterior = vidaAtual;
            if (client.method_1493() && !(client.field_1755 instanceof InvisiblePauseScreen)) {
                return;
            }
            if (this.isMemeActive) {
                --this.ticksMemeAtivo;
                int duracaoTotal = PhonkEditModClient.config.duracaoEfeitoSegundos * 20;
                effectProgress = 1.0f - (float)this.ticksMemeAtivo / (float)duracaoTotal;
                float baseBPM = 140.0f;
                float adjustedBPM = baseBPM * currentPitch;
                float beatsPerSecond = adjustedBPM / 60.0f;
                ticksPerBeat = (int)Math.max(3.0f, 20.0f / beatsPerSecond);
                int ticksInCurrentBeat = (duracaoTotal - this.ticksMemeAtivo) % ticksPerBeat;
                beatProgress = (float)ticksInCurrentBeat / (float)ticksPerBeat;
                float beatIntensity = (float)Math.pow(1.0f - beatProgress, 3.0);
                targetZoom = PhonkEditModClient.config.habilitarZoom ? 1.0f + beatIntensity * 0.3f * PhonkEditModClient.config.intensidadeZoom : 1.0f;
                blurIntensity = PhonkEditModClient.config.habilitarBlur ? beatIntensity * 0.8f * PhonkEditModClient.config.intensidadeBlur : 0.0f;
                if (PhonkEditModClient.config.habilitarShake) {
                    float baseShake = 0.15f;
                    float beatShake = beatIntensity * 0.25f;
                    if (effectProgress > 0.9f) {
                        float finalIntensity = (effectProgress - 0.9f) * 10.0f;
                        baseShake += finalIntensity * 0.3f;
                        beatShake += finalIntensity * 0.2f;
                    }
                    shakeIntensity = (baseShake + beatShake) * PhonkEditModClient.config.intensidadeShake;
                } else {
                    shakeIntensity = 0.0f;
                }
                if (this.ticksMemeAtivo <= 0) {
                    this.pararMeme(client);
                }
                if (Math.abs(currentZoom - targetZoom) > 0.001f) {
                    currentZoom += (targetZoom - currentZoom) * 0.3f;
                }
            } else if (PhonkEditModClient.config.habilitarTimerAleatorio) {
                if (this.ticksParaProximoMeme == -1) {
                    this.ticksParaProximoMeme = this.getTempoAleatorio();
                }
                --this.ticksParaProximoMeme;
                if (this.ticksParaProximoMeme <= 0) {
                    if (PhonkEditModClient.config.timerIgnoraChance || this.random.nextFloat() < PhonkEditModClient.config.chanceAtivarPorAcao) {
                        this.iniciarMeme(client);
                    } else {
                        this.ticksParaProximoMeme = this.getTempoAleatorio();
                    }
                }
            }
        });
    }

    private void iniciarMeme(class_310 client) {
        this.isMemeActive = true;
        this.ticksMemeAtivo = PhonkEditModClient.config.duracaoEfeitoSegundos * 20;
        this.ticksParaProximoMeme = this.getTempoAleatorio();
        client.method_1507((class_437)new InvisiblePauseScreen());
        float pitchRange = PhonkEditModClient.config.pitchMaximo - PhonkEditModClient.config.pitchMinimo;
        float pitchAleatorio = PhonkEditModClient.config.pitchMinimo + this.random.nextFloat() * pitchRange;
        this.somMemeAtual = this.selecionarETocarSom(client, pitchAleatorio);
        currentPitch = pitchAleatorio;
        this.imagemMemeAtual = this.selecionarImagemAleatoria();
        this.textoMemeAtual = MEME_TEXTS[this.random.nextInt(MEME_TEXTS.length)];
        applyCameraEffects = true;
        currentZoom = 1.0f;
        targetZoom = 1.0f;
        shakeIntensity = 0.15f;
        blurIntensity = 0.0f;
        beatProgress = 0.0f;
    }

    private void pararMeme(class_310 client) {
        if (!this.isMemeActive) {
            return;
        }
        this.isMemeActive = false;
        this.ticksMemeAtivo = 0;
        client.method_1507(null);
        if (this.somMemeAtual != null) {
            client.method_1483().method_4870(this.somMemeAtual);
            this.somMemeAtual = null;
        }
        applyCameraEffects = false;
        currentZoom = 1.0f;
        targetZoom = 1.0f;
        shakeIntensity = 0.0f;
        blurIntensity = 0.0f;
        effectProgress = 0.0f;
        beatProgress = 0.0f;
        currentPitch = 1.0f;
    }

    private void registerHudRenderer() {
        HudRenderCallback.EVENT.register((drawContext, tickCounter) -> {
            int targetWidth;
            int barWidth;
            if (!this.isMemeActive) {
                return;
            }
            class_310 client = class_310.method_1551();
            int screenWidth = client.method_22683().method_4486();
            int screenHeight = client.method_22683().method_4502();
            if (PhonkEditModClient.config.habilitarShake && applyCameraEffects && shakeIntensity > 0.0f) {
                float shakeX = (float)(Math.random() - 0.5) * shakeIntensity * 10.0f;
                float shakeY = (float)(Math.random() - 0.5) * shakeIntensity * 10.0f;
                drawContext.method_51448().method_22903();
                drawContext.method_51448().method_46416(shakeX, shakeY, 0.0f);
            }
            if (PhonkEditModClient.config.habilitarBarrasPretas || PhonkEditModClient.config.habilitarGrayscale) {
                float grayscaleIntensity = PhonkEditModClient.config.habilitarGrayscale ? 1.0f : 0.0f;
                GRAYSCALE_SHADER.setUniformValue("Intensity", grayscaleIntensity);
                GRAYSCALE_SHADER.render(tickCounter.method_60637(false));
            }
            if (PhonkEditModClient.config.habilitarBlur && blurIntensity > 0.01f) {
                RADIAL_BLUR_SHADER.setUniformValue("BlurIntensity", blurIntensity);
                RADIAL_BLUR_SHADER.render(tickCounter.method_60637(false));
            }
            if (PhonkEditModClient.config.habilitarTextoMeme && this.textoMemeAtual != null) {
                int textY = 30;
                int textColor = 0xFFFFFF;
                int shadowColor = 0;
                int textWidth = client.field_1772.method_1727(this.textoMemeAtual);
                int textX = (screenWidth - textWidth) / 2;
                drawContext.method_51433(client.field_1772, this.textoMemeAtual, textX + 2, textY + 2, shadowColor, false);
                drawContext.method_51433(client.field_1772, this.textoMemeAtual, textX, textY, textColor, false);
            }
            if (PhonkEditModClient.config.habilitarIconeCaveira && this.imagemMemeAtual != null) {
                int renderSize = PhonkEditModClient.config.tamanhoIcone;
                int x = (screenWidth - renderSize) / 2;
                int y_center_point = screenHeight * 3 / 4;
                int y = y_center_point - renderSize / 2;
                drawContext.method_25293(this.imagemMemeAtual, x, y, renderSize, renderSize, 0.0f, 0.0f, 512, 512, 512, 512);
            }
            if (PhonkEditModClient.config.habilitarShake && applyCameraEffects && shakeIntensity > 0.0f) {
                drawContext.method_51448().method_22909();
            }
            if (PhonkEditModClient.config.habilitarBarrasPretas && (barWidth = (screenWidth - (targetWidth = screenHeight * 9 / 16)) / 2) > 0) {
                drawContext.method_25294(0, 0, barWidth, screenHeight, -16777216);
                drawContext.method_25294(screenWidth - barWidth, 0, screenWidth, screenHeight, -16777216);
            }
        });
    }

    private int getTempoAleatorio() {
        int minTicks = PhonkEditModClient.config.minSegundosEntreEfeitos * 20;
        int maxTicks = PhonkEditModClient.config.maxSegundosEntreEfeitos * 20;
        return this.random.nextInt(minTicks, maxTicks + 1);
    }

    private void registerActionTriggers() {
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (PhonkEditModClient.config.habilitarTriggerAtaque) {
                this.tentarAtivarMemePorAcaoComDelay();
            }
            return class_1269.field_5811;
        });
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, blockEntity) -> {
            if (PhonkEditModClient.config.habilitarTriggerQuebrarBloco) {
                this.tentarAtivarMemePorAcaoComDelay();
            }
        });
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (PhonkEditModClient.config.habilitarTriggerUsarBloco) {
                this.tentarAtivarMemePorAcaoComDelay();
            }
            return class_1269.field_5811;
        });
        UseItemCallback.EVENT.register((player, world, hand) -> {
            if (PhonkEditModClient.config.habilitarTriggerUsarItem) {
                this.tentarAtivarMemePorAcaoComDelay();
            }
            return class_1271.method_22430((Object)player.method_5998(hand));
        });
    }

    private void tentarAtivarMemePorAcaoComDelay() {
        if (this.isMemeActive) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        if (this.random.nextFloat() < PhonkEditModClient.config.chanceAtivarPorAcao) {
            this.scheduler.schedule(() -> client.execute(() -> {
                if (!this.isMemeActive) {
                    this.iniciarMeme(client);
                }
            }), (long)PhonkEditModClient.config.delayAcaoMs, TimeUnit.MILLISECONDS);
        }
    }

    public static boolean shouldApplyCameraEffects() {
        return applyCameraEffects;
    }

    public static float getZoomLevel() {
        return currentZoom;
    }

    public static float getShakeIntensity() {
        return shakeIntensity;
    }

    public static float getBlurIntensity() {
        return blurIntensity;
    }

    public static float getEffectProgress() {
        return effectProgress;
    }

    public static void reiniciarTimer() {
        if (instance != null && !PhonkEditModClient.instance.isMemeActive) {
            PhonkEditModClient.instance.ticksParaProximoMeme = instance.getTempoAleatorio();
        }
    }

    public static float getBeatProgress() {
        return beatProgress;
    }

    private class_1113 selecionarETocarSom(class_310 client, float pitch) {
        List<class_3414> customSounds = CustomSoundDetector.getCustomSounds();
        switch (PhonkEditModClient.config.audioMode) {
            case MOD_ONLY: {
                class_3414 somMod = MEME_SOUNDS[this.random.nextInt(MEME_SOUNDS.length)];
                class_1109 instanceMod = class_1109.method_4757((class_3414)somMod, (float)pitch, (float)PhonkEditModClient.config.volumeMusica);
                client.method_1483().method_4873((class_1113)instanceMod);
                return instanceMod;
            }
            case CUSTOM_ONLY: {
                if (!customSounds.isEmpty()) {
                    class_3414 somCustom = customSounds.get(this.random.nextInt(customSounds.size()));
                    class_1109 instanceCustom = class_1109.method_4757((class_3414)somCustom, (float)pitch, (float)PhonkEditModClient.config.volumeMusica);
                    client.method_1483().method_4873((class_1113)instanceCustom);
                    System.out.println("[Phonk Edit Mod] Tocando som customizado via resource pack");
                    return instanceCustom;
                }
                System.out.println("[Phonk Edit Mod] Nenhum som customizado encontrado, usando som do mod");
                class_3414 somFallback = MEME_SOUNDS[this.random.nextInt(MEME_SOUNDS.length)];
                class_1109 instanceFallback = class_1109.method_4757((class_3414)somFallback, (float)pitch, (float)PhonkEditModClient.config.volumeMusica);
                client.method_1483().method_4873((class_1113)instanceFallback);
                return instanceFallback;
            }
            case MIX: {
                ArrayList<class_3414> allSounds = new ArrayList<class_3414>();
                for (class_3414 sound : MEME_SOUNDS) {
                    allSounds.add(sound);
                }
                allSounds.addAll(customSounds);
                if (allSounds.isEmpty()) {
                    class_3414 somDefault = MEME_SOUNDS[0];
                    class_1109 instanceDefault = class_1109.method_4757((class_3414)somDefault, (float)pitch, (float)PhonkEditModClient.config.volumeMusica);
                    client.method_1483().method_4873((class_1113)instanceDefault);
                    return instanceDefault;
                }
                class_3414 somMix = (class_3414)allSounds.get(this.random.nextInt(allSounds.size()));
                class_1109 instanceMix = class_1109.method_4757((class_3414)somMix, (float)pitch, (float)PhonkEditModClient.config.volumeMusica);
                client.method_1483().method_4873((class_1113)instanceMix);
                return instanceMix;
            }
        }
        class_3414 somPadrao = MEME_SOUNDS[this.random.nextInt(MEME_SOUNDS.length)];
        class_1109 instancePadrao = class_1109.method_4757((class_3414)somPadrao, (float)pitch, (float)PhonkEditModClient.config.volumeMusica);
        client.method_1483().method_4873((class_1113)instancePadrao);
        return instancePadrao;
    }

    private class_2960 selecionarImagemAleatoria() {
        List<class_2960> customImages = CustomResourceManager.getCustomImages();
        switch (PhonkEditModClient.config.imageMode) {
            case MOD_ONLY: {
                return MEME_IMAGES[this.random.nextInt(MEME_IMAGES.length)];
            }
            case CUSTOM_ONLY: {
                if (!customImages.isEmpty()) {
                    return customImages.get(this.random.nextInt(customImages.size()));
                }
                System.out.println("[Phonk Edit Mod] Nenhuma imagem customizada encontrada, usando imagem do mod");
                return MEME_IMAGES[this.random.nextInt(MEME_IMAGES.length)];
            }
            case MIX: {
                ArrayList<class_2960> allImages = new ArrayList<class_2960>();
                for (class_2960 image : MEME_IMAGES) {
                    allImages.add(image);
                }
                allImages.addAll(customImages);
                if (allImages.isEmpty()) {
                    return MEME_IMAGES[0];
                }
                return (class_2960)allImages.get(this.random.nextInt(allImages.size()));
            }
        }
        return MEME_IMAGES[this.random.nextInt(MEME_IMAGES.length)];
    }

    public static void reloadCustomResources(boolean showNotification) {
        try {
            int audioErrors = CustomResourceManager.detectInvalidAudioFiles();
            CustomResourceManager.loadCustomResources();
            CustomSoundDetector.detectCustomSounds();
            System.out.println("[Phonk Edit Mod] Recursos customizados recarregados!");
            if (showNotification && instance != null) {
                int totalSoundsInJson = CustomSoundDetector.getCustomSoundCount();
                int validAudioCount = Math.max(0, totalSoundsInJson - audioErrors);
                int imageCount = CustomResourceManager.getCustomImages().size();
                int imageErrors = CustomResourceManager.getLastImageErrors();
                instance.showResourceNotifications(validAudioCount, audioErrors, imageCount, imageErrors);
            }
        }
        catch (Exception e) {
            System.err.println("[Phonk Edit Mod] Erro ao recarregar recursos customizados: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void reloadCustomResources() {
        PhonkEditModClient.reloadCustomResources(false);
    }

    private void showResourceNotifications(int validAudioCount, int audioErrors, int imageCount, int imageErrors) {
        long delay;
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null) {
            return;
        }
        if (validAudioCount > 0) {
            NotificationToast.showAudioLoaded(validAudioCount);
        }
        if (audioErrors > 0) {
            this.scheduler.schedule(() -> client.execute(() -> NotificationToast.showAudioErrors(audioErrors)), 200L, TimeUnit.MILLISECONDS);
        }
        if (imageCount > 0) {
            delay = audioErrors > 0 ? 400L : 200L;
            this.scheduler.schedule(() -> client.execute(() -> NotificationToast.showImagesLoaded(imageCount)), delay, TimeUnit.MILLISECONDS);
        }
        if (imageErrors > 0) {
            delay = imageCount > 0 ? 600L : 400L;
            this.scheduler.schedule(() -> client.execute(() -> NotificationToast.showImageErrors(imageErrors)), delay, TimeUnit.MILLISECONDS);
        }
    }

    public static void scheduleTask(Runnable task, long delayMs) {
        if (instance != null && PhonkEditModClient.instance.scheduler != null) {
            PhonkEditModClient.instance.scheduler.schedule(task, delayMs, TimeUnit.MILLISECONDS);
        }
    }

    static {
        MEME_IMAGES = new class_2960[]{class_2960.method_60655((String)"phonk-edit-mod", (String)"textures/gui/caveira1.png"), class_2960.method_60655((String)"phonk-edit-mod", (String)"textures/gui/caveira2.png"), class_2960.method_60655((String)"phonk-edit-mod", (String)"textures/gui/caveira3.png"), class_2960.method_60655((String)"phonk-edit-mod", (String)"textures/gui/caveira4.png"), class_2960.method_60655((String)"phonk-edit-mod", (String)"textures/gui/caveira5.png"), class_2960.method_60655((String)"phonk-edit-mod", (String)"textures/gui/caveira6.png"), class_2960.method_60655((String)"phonk-edit-mod", (String)"textures/gui/caveira7.png"), class_2960.method_60655((String)"phonk-edit-mod", (String)"textures/gui/caveira8.png"), class_2960.method_60655((String)"phonk-edit-mod", (String)"textures/gui/caveira9.png"), class_2960.method_60655((String)"phonk-edit-mod", (String)"textures/gui/caveira10.png")};
        MEME_SOUNDS = new class_3414[]{class_3414.method_47908((class_2960)class_2960.method_60655((String)"phonk-edit-mod", (String)"phonk1")), class_3414.method_47908((class_2960)class_2960.method_60655((String)"phonk-edit-mod", (String)"phonk2")), class_3414.method_47908((class_2960)class_2960.method_60655((String)"phonk-edit-mod", (String)"phonk3")), class_3414.method_47908((class_2960)class_2960.method_60655((String)"phonk-edit-mod", (String)"phonk4")), class_3414.method_47908((class_2960)class_2960.method_60655((String)"phonk-edit-mod", (String)"phonk5")), class_3414.method_47908((class_2960)class_2960.method_60655((String)"phonk-edit-mod", (String)"phonk6")), class_3414.method_47908((class_2960)class_2960.method_60655((String)"phonk-edit-mod", (String)"phonk7")), class_3414.method_47908((class_2960)class_2960.method_60655((String)"phonk-edit-mod", (String)"phonk8")), class_3414.method_47908((class_2960)class_2960.method_60655((String)"phonk-edit-mod", (String)"phonk9"))};
        MEME_TEXTS = new String[]{"THOSE WHO KNOW", "WHEN I ENTER THE GAME", "POV: YOU'RE TOO GOOD", "MOMENTS BEFORE DISASTER", "MINECRAFT EDIT \ud83d\udd25", "THIS IS GOING TO BE EPIC", "SIGMA GRINDSET", "COLD AS ICE \u2744\ufe0f", "BRO...", "I AM INEVITABLE", "LITERALLY ME", "MAIN CHARACTER MOMENT", "NOBODY CAN STOP ME", "THIS IS HOW I PLAY", "LEGENDARY"};
        applyCameraEffects = false;
        currentZoom = 1.0f;
        targetZoom = 1.0f;
        shakeIntensity = 0.0f;
        blurIntensity = 0.0f;
        effectProgress = 0.0f;
        currentPitch = 1.0f;
        beatProgress = 0.0f;
        ticksPerBeat = 10;
        GRAYSCALE_SHADER = ShaderEffectManager.getInstance().manage(class_2960.method_60655((String)"phonk-edit-mod", (String)"shaders/post/grayscale.json"));
        RADIAL_BLUR_SHADER = ShaderEffectManager.getInstance().manage(class_2960.method_60655((String)"phonk-edit-mod", (String)"shaders/post/radial_blur.json"));
        PASSTHROUGH_SHADER = ShaderEffectManager.getInstance().manage(class_2960.method_60655((String)"phonk-edit-mod", (String)"shaders/post/blit.json"));
    }
}

