/*
 * Decompiled with CFR 0.152.
 */
package com.luigi.phonkeditmod;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_3283;

@Environment(value=EnvType.CLIENT)
public class TutorialResourcePackGenerator {
    private static final String PACK_NAME = "PhonkEdit-CustomSongs";

    public static void generateIfNeeded() {
        try {
            Path minecraftDir = Paths.get(System.getProperty("user.dir"), new String[0]);
            Path resourcepacksDir = minecraftDir.resolve("resourcepacks");
            Path tutorialPackDir = resourcepacksDir.resolve(PACK_NAME);
            if (Files.exists(tutorialPackDir, new LinkOption[0])) {
                System.out.println("[Phonk Edit Mod] Tutorial pack j\u00e1 existe: " + String.valueOf(tutorialPackDir));
                return;
            }
            System.out.println("[Phonk Edit Mod] Gerando tutorial pack em: " + String.valueOf(tutorialPackDir));
            Path assetsDir = tutorialPackDir.resolve("assets/phonk-edit-mod/sounds/custom");
            Files.createDirectories(assetsDir, new FileAttribute[0]);
            TutorialResourcePackGenerator.generatePackMcmeta(tutorialPackDir);
            TutorialResourcePackGenerator.generateSoundsJson(tutorialPackDir);
            TutorialResourcePackGenerator.generateHowTo(tutorialPackDir);
            TutorialResourcePackGenerator.generatePlaceholder(assetsDir);
            System.out.println("[Phonk Edit Mod] Tutorial pack gerado com sucesso!");
            System.out.println("[Phonk Edit Mod] Localiza\u00e7\u00e3o: " + String.valueOf(tutorialPackDir));
            System.out.println("[Phonk Edit Mod] O pack ser\u00e1 ativado automaticamente no primeiro tick do jogo!");
            System.out.println("[Phonk Edit Mod] Adicione seus arquivos OGG na pasta 'custom/' e pressione F3+T para recarregar!");
        }
        catch (IOException e) {
            System.err.println("[Phonk Edit Mod] Erro ao gerar tutorial pack: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void enablePackAutomatically() {
        try {
            class_310 client = class_310.method_1551();
            if (client == null) {
                System.err.println("[Phonk Edit Mod] MinecraftClient n\u00e3o dispon\u00edvel ainda, n\u00e3o \u00e9 poss\u00edvel ativar pack");
                return;
            }
            class_3283 packManager = client.method_1520();
            String packProfileName = "file/PhonkEdit-CustomSongs";
            ArrayList<String> enabledPacks = new ArrayList<String>(packManager.method_29210());
            if (enabledPacks.contains(packProfileName)) {
                System.out.println("[Phonk Edit Mod] Pack j\u00e1 est\u00e1 habilitado: " + packProfileName);
                return;
            }
            enabledPacks.add(packProfileName);
            packManager.method_14447(enabledPacks);
            System.out.println("[Phonk Edit Mod] Pack habilitado automaticamente: " + packProfileName);
            System.out.println("[Phonk Edit Mod] O pack estar\u00e1 ativo no pr\u00f3ximo reload de recursos!");
        }
        catch (Exception e) {
            System.err.println("[Phonk Edit Mod] Erro ao ativar pack automaticamente: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void generatePackMcmeta(Path packDir) throws IOException {
        String content = "{\n  \"pack\": {\n    \"pack_format\": 34,\n    \"description\": \"\u00a76Tutorial: Custom Phonk Songs\\n\u00a77Add your own phonk tracks here!\"\n  }\n}\n";
        Path file = packDir.resolve("pack.mcmeta");
        Files.writeString(file, (CharSequence)content, StandardOpenOption.CREATE);
    }

    private static void generateSoundsJson(Path packDir) throws IOException {
        String content = "{\n}\n";
        Path file = packDir.resolve("assets/phonk-edit-mod/sounds.json");
        Files.writeString(file, (CharSequence)content, StandardOpenOption.CREATE);
        String readmeContent = "=============================================================================\n  HOW TO ADD CUSTOM PHONK SONGS - sounds.json\n=============================================================================\n\n1. Place your .ogg audio files in: sounds/custom/\n   Example: sounds/custom/test_phonk.ogg\n\n2. Add entries to sounds.json following this format:\n\n   {\n     \"custom/test_phonk\": {\n       \"sounds\": [ \"phonk-edit-mod:custom/test_phonk\" ],\n       \"subtitle\": \"Test Phonk\"\n     },\n     \"custom/another_song\": {\n       \"sounds\": [ \"phonk-edit-mod:custom/another_song\" ]\n     }\n   }\n\n3. IMPORTANT:\n   - Keys MUST start with \"custom/\"\n   - File name must match (without .ogg extension)\n   - Don't forget commas between entries!\n   - Last entry should NOT have a comma\n\n4. This pack is ALREADY ENABLED!\n   Just press F3+T to reload resources\n\n5. In-game: Press 'O' -> Set Audio Mode to 'Mix' or 'Custom Only'\n\n=============================================================================\n";
        Path readmeFile = packDir.resolve("assets/phonk-edit-mod/SOUNDS_JSON_GUIDE.txt");
        Files.writeString(readmeFile, (CharSequence)readmeContent, StandardOpenOption.CREATE);
    }

    private static void generateHowTo(Path packDir) throws IOException {
        String content = "==============================================================================\n  PHONK EDIT MOD - CUSTOM SONGS TUTORIAL\n==============================================================================\n\nWelcome! This resource pack lets you add your own phonk songs to the mod.\n\n--- QUICK START (5 minutes) ---\n\n1. CONVERT YOUR SONGS TO OGG\n   - Use Audacity: File -> Export -> OGG Vorbis\n   - Or online: https://convertio.co/mp3-ogg/\n\n2. ADD OGG FILES\n   - Place your .ogg files in:\n     assets/phonk-edit-mod/sounds/custom/\n   - Example: custom/test_phonk.ogg\n\n3. REGISTER IN SOUNDS.JSON\n   - Open: assets/phonk-edit-mod/sounds.json\n   - Add entry:\n     {\n       \"custom/test_phonk\": {\n         \"sounds\": [ \"phonk-edit-mod:custom/test_phonk\" ]\n       }\n     }\n   - IMPORTANT: Key must start with \"custom/\"\n   - IMPORTANT: Name must match file (without .ogg)\n\n4. RELOAD RESOURCES\n   - This pack is ALREADY ENABLED automatically!\n   - Just press F3+T to reload resources\n   - Or press 'O' -> Click \"Reload Custom Files\"\n\n5. CONFIGURE MOD\n   - Enter a world\n   - Press 'O' key (opens config menu)\n   - Set \"Audio Mode\" to \"Mix\" or \"Custom Only\"\n\n6. ENJOY!\n   - Play normally and wait for the effect\n   - Your custom phonk will play!\n\n--- AUDIO MODES ---\n\n- Mod Only: Uses only 9 original phonk tracks (default)\n- Mix: Random between original and custom tracks (RECOMMENDED)\n- Custom Only: Uses only your custom tracks\n\n--- FILE REQUIREMENTS ---\n\nFormat: OGG Vorbis (NOT MP3, WAV, FLAC)\nSample Rate: 44100 Hz recommended\nBitrate: 128-192 kbps\nDuration: Any (5-30 seconds recommended for phonk)\n\n--- TROUBLESHOOTING ---\n\nQ: \"No custom sounds detected\"\nA: 1. Pack is auto-enabled, but verify in Options -> Resource Packs\n   2. Verify sounds.json has entries starting with \"custom/\"\n   3. Press F3+T or click \"Reload Custom Files\" (press O)\n   4. Check logs: .minecraft/logs/latest.log\n\nQ: \"Sound doesn't play\"\nA: 1. Verify .ogg file exists in custom/ folder\n   2. Check filename matches sounds.json exactly\n   3. Ensure file is valid OGG (test in VLC)\n   4. Set Audio Mode to \"Custom Only\" to test\n\nQ: \"JSON syntax error\"\nA: 1. Validate at: https://jsonlint.com/\n   2. Check all quotes are \" (not ' or smart quotes)\n   3. Verify commas between entries (not after last)\n\n--- EXAMPLE ---\n\nLet's add \"Shadowboxing - DVRST\":\n\n1. Download from YouTube -> Convert to OGG\n2. Rename to: shadowboxing.ogg\n3. Move to: assets/phonk-edit-mod/sounds/custom/\n4. Edit sounds.json:\n   {\n     \"custom/shadowboxing\": {\n       \"sounds\": [ \"phonk-edit-mod:custom/shadowboxing\" ]\n     }\n   }\n5. Press F3+T or O -> Reload Custom Files to reload resources (pack is already enabled!)\n6. O -> Set Audio Mode: Mix\n7. Play and enjoy!\n\n==============================================================================\n";
        Path file = packDir.resolve("HOW_TO.txt");
        Files.writeString(file, (CharSequence)content, StandardOpenOption.CREATE);
    }

    private static void generatePlaceholder(Path customDir) throws IOException {
        String content = "==============================================================================\n  PLACE YOUR .OGG FILES HERE!\n==============================================================================\n\nThis folder is where you put your custom phonk songs.\n\nSTEPS:\n\n1. Convert your songs to OGG Vorbis format\n   - Use Audacity or online converters\n\n2. Place .ogg files in THIS folder\n   - Example: test_phonk.ogg\n\n3. Register in ../sounds.json\n   - Add entry: \"custom/test_phonk\": {...}\n\n4. Press F3+T to reload resources\n   - Pack is already enabled automatically!\n\n5. In-game: Press O -> Set Audio Mode to Mix/Custom Only\n\nSee HOW_TO.txt in the pack root for full instructions!\n\n==============================================================================\n";
        Path file = customDir.resolve("PLACE_OGG_FILES_HERE.txt");
        Files.writeString(file, (CharSequence)content, StandardOpenOption.CREATE);
    }
}

