/*
 * Decompiled with CFR 0.152.
 */
package net.jamicah.arduinocraft.arduino;

import com.fazecast.jSerialComm.SerialPort;
import java.io.IOException;
import java.io.InputStream;
import net.jamicah.arduinocraft.Arduinocraft;
import net.jamicah.arduinocraft.Chat;
import net.jamicah.arduinocraft.block.custom.Arduino_Block;

public class SerialCom {
    public SerialPort comPort;
    public InputStream comPortIn;
    public static Boolean isOpened = false;
    public static volatile Boolean isReceivingInput = false;
    public static volatile int analogSignal = 0;
    public static Boolean hasSentArduinoMessage = false;
    public static StringBuilder messageBuffer = new StringBuilder();
    private Thread readerThread;

    public SerialCom(String port, int baudrate) {
        this.comPort = SerialPort.getCommPort(port);
        this.comPort.setComPortParameters(baudrate, 8, 1, 0);
        this.comPort.setComPortTimeouts(0, 0, 0);
        if (this.comPort.openPort()) {
            try {
                this.comPortIn = this.comPort.getInputStream();
            }
            catch (Exception e) {
                Chat.sendMessage("\u00a7cFailed to get input stream: " + e.getMessage());
                isOpened = false;
                return;
            }
            Chat.sendMessage("\u00a7aCommunication successfully started");
            isOpened = true;
            this.readerThread = new Thread(this::readerLoop, "Arduino-Serial-Reader");
            this.readerThread.setDaemon(true);
            this.readerThread.start();
        } else {
            Chat.sendMessage("\u00a7cSomething went wrong, the inputted port might be wrong");
            isOpened = false;
        }
    }

    public static void digitalWrite(SerialPort com, Integer signal) {
        try {
            com.getOutputStream().write(signal.byteValue());
        }
        catch (IOException e) {
            Chat.sendMessage("An error has occurred. Debug info: " + e);
        }
        try {
            com.getOutputStream().flush();
        }
        catch (IOException e) {
            Chat.sendMessage("An error has occurred. Debug info: " + e);
        }
    }

    /*
     * Exception decompiling
     */
    private void readerLoop() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Boolean digitalRead(InputStream in) {
        if (in == null) {
            Arduinocraft.LOGGER.warn("SerialCom.digitalRead called with null InputStream");
            return null;
        }
        try {
            if (in.available() > 0) {
                int read = in.read();
                if (read == -1) {
                    return null;
                }
                Arduinocraft.LOGGER.info("SerialCom.digitalRead raw byte: " + read);
                if (read == 3 || read == 51) {
                    return true;
                }
                if (read == 4 || read == 52) {
                    return false;
                }
            }
        }
        catch (IOException e) {
            Chat.sendMessage("\u00a7cAn error has occurred while trying to read Arduino's signal");
            Arduinocraft.LOGGER.error("Error reading from serial input stream", (Throwable)e);
        }
        return null;
    }

    @Deprecated
    public static void analogRead() {
        Arduinocraft.LOGGER.info("SerialCom.analogRead() (deprecated) called \u2014 use readerThread instead");
        while (Arduino_Block.isAnalog.booleanValue() && isOpened.booleanValue()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ignored) {
                break;
            }
        }
    }

    public static void closePort(SerialPort comPort) {
        try {
            if (Arduinocraft.comPort != null && Arduinocraft.comPort.readerThread != null) {
                Arduinocraft.comPort.readerThread.interrupt();
                Arduinocraft.comPort.readerThread = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (comPort.closePort()) {
            Arduinocraft.LOGGER.info("Successfully closed Serial Communication");
            isOpened = false;
        } else {
            Arduinocraft.LOGGER.info("An error has occurred while trying to close the Serial Communication");
        }
    }
}

