/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.custombiomecolors;

import com.fastasyncworldedit.core.FaweAPI;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.biome.BiomeReplace;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.visitor.RegionVisitor;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import io.github.lumine1909.custombiomecolors.CustomBiomeColors;
import io.github.lumine1909.custombiomecolors.data.DataManager;
import io.github.lumine1909.custombiomecolors.nms.BiomeAccessor;
import io.github.lumine1909.custombiomecolors.nms.ServerDataHandler;
import io.github.lumine1909.custombiomecolors.object.BiomeKey;
import io.github.lumine1909.custombiomecolors.object.ColorData;
import io.github.lumine1909.custombiomecolors.object.ColorType;
import io.github.lumine1909.custombiomecolors.util.StringUtil;
import org.bukkit.Location;

public class BiomeManager {
    private final ServerDataHandler serverDataHandler = CustomBiomeColors.getInstance().getServerDataHandler();
    private final DataManager dataManager = CustomBiomeColors.getInstance().getDataManager();

    private static BiomeType getOrCreate(String id) {
        BiomeType biomeType = BiomeTypes.get((String)id);
        if (biomeType != null) {
            return biomeType;
        }
        biomeType = new BiomeType(id);
        BiomeTypes.register((BiomeType)biomeType);
        return biomeType;
    }

    public void changeBiomeColor(org.bukkit.entity.Player player, Region region, ColorType colorType, int color, Runnable runWhenDone) {
        this.changeBiomeColor(player, region, colorType, color, new BiomeKey("cbc", StringUtil.randomString(10)), false, runWhenDone);
    }

    public void changeBiomeColor(org.bukkit.entity.Player player, Region region, ColorType colorType, int color, BiomeKey biomeKey, boolean forceKey, Runnable runWhenDone) {
        BukkitPlayer wePlayer = BukkitAdapter.adapt((org.bukkit.entity.Player)player);
        World weWorld = BukkitAdapter.adapt((org.bukkit.World)player.getWorld());
        FaweAPI.getTaskManager().async(() -> this.lambda$changeBiomeColor$1(weWorld, (Player)wePlayer, region, player, colorType, color, forceKey, biomeKey, runWhenDone));
    }

    private /* synthetic */ void lambda$changeBiomeColor$1(World weWorld, Player wePlayer, Region region, org.bukkit.entity.Player player, ColorType colorType, int color, boolean forceKey, BiomeKey biomeKey, Runnable runWhenDone) {
        try (EditSession editSession = WorldEdit.getInstance().newEditSessionBuilder().world(weWorld).fastMode(Boolean.valueOf(true)).actor((Actor)wePlayer).build();){
            editSession.setReorderMode(EditSession.ReorderMode.FAST);
            BlockVector3 pos = region.getMinimumPoint();
            Location loc = new Location(player.getWorld(), (double)pos.x(), (double)pos.y(), (double)pos.z());
            BiomeAccessor biome = this.serverDataHandler.wrapToAccessor(this.serverDataHandler.getBiomeAt(loc));
            ColorData colorData = biome.getBiomeData().colorData().mutable().set(colorType, color).build();
            BiomeAccessor newBiome = this.dataManager.getBiomeByColorOrElse(forceKey, colorData, () -> biome.cloneWithDifferentColor(this.serverDataHandler, biomeKey, colorData));
            BiomeType type = BiomeManager.getOrCreate(newBiome.getBiomeData().biomeKey().toString());
            BiomeReplace replace = new BiomeReplace((Extent)editSession, type);
            RegionVisitor visitor = new RegionVisitor(region, (RegionFunction)replace);
            Operations.completeLegacy((Operation)visitor);
            editSession.flushQueue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        runWhenDone.run();
    }
}

