/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.custombiomecolors.command;

import io.github.lumine1909.custombiomecolors.CustomBiomeColors;
import io.github.lumine1909.custombiomecolors.nms.BiomeAccessor;
import io.github.lumine1909.custombiomecolors.nms.ServerDataHandler;
import io.github.lumine1909.custombiomecolors.object.BiomeData;
import io.github.lumine1909.custombiomecolors.object.ColorData;
import io.github.lumine1909.custombiomecolors.object.ColorType;
import io.github.lumine1909.custombiomecolors.util.MessageUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GetBiomeColorsCommand
implements TabExecutor {
    private static final ServerDataHandler BIOME_DATA_HANDLER = CustomBiomeColors.getInstance().getServerDataHandler();

    public GetBiomeColorsCommand() {
        Objects.requireNonNull(Bukkit.getPluginCommand((String)"/getbiomecolors")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(Bukkit.getPluginCommand((String)"/getbiomecolors")).setTabCompleter((TabCompleter)this);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String @NotNull [] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        BiomeAccessor biome = BIOME_DATA_HANDLER.wrapToAccessor(BIOME_DATA_HANDLER.getBiomeAt(player.getLocation()));
        BiomeData biomeData = biome.getBiomeData();
        player.sendMessage(Component.text((String)("Colors of the biome you are in (" + String.valueOf(biomeData.biomeKey()) + "): "), (TextColor)NamedTextColor.GREEN).decorate(TextDecoration.BOLD));
        ColorData biomeColor = biomeData.colorData();
        ColorData dimensionColor = CustomBiomeColors.getInstance().getServerDataHandler().getDimensionColor(player.getLocation());
        for (ColorType colorType : ColorType.values()) {
            Integer color;
            TextComponent message = Component.text((String)(" - " + colorType.messageName() + ": "), (TextColor)NamedTextColor.GRAY);
            boolean shouldSend = false;
            if (biomeColor != null && (color = biomeColor.get(colorType)) != null) {
                message = message.append(MessageUtil.getColorMessage(colorType, color, biome.getTemperature(), biome.getHumidity()).decorate(TextDecoration.BOLD)).append((Component)Component.text((String)" (Biome)    ", (TextColor)NamedTextColor.GRAY));
                shouldSend = true;
            }
            if (dimensionColor != null && (color = dimensionColor.get(colorType)) != null) {
                message = message.append(MessageUtil.getColorMessage(colorType, color, 0.0f, 0.0f).decorate(TextDecoration.BOLD)).append((Component)Component.text((String)" (Dimension)    ", (TextColor)NamedTextColor.GRAY));
                shouldSend = true;
            }
            if (!shouldSend) continue;
            player.sendMessage((Component)message);
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        return Collections.emptyList();
    }
}

