/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.custombiomecolors.command;

import io.github.lumine1909.custombiomecolors.object.ColorType;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnsupportedCommand
implements TabExecutor {
    private final String supportSince;

    public UnsupportedCommand(String supportSince) {
        this.supportSince = supportSince;
    }

    public static void register(@Nullable PluginCommand command, ColorType colorType) {
        if (command == null) {
            throw new RuntimeException("Unable to register command, command is null");
        }
        UnsupportedCommand unsupportedCommand = new UnsupportedCommand(colorType.getSupportSince());
        command.setExecutor((CommandExecutor)unsupportedCommand);
        command.setTabCompleter((TabCompleter)unsupportedCommand);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        sender.sendMessage((Component)Component.text((String)("This command uses a feature introduced in version " + this.supportSince + ", which is currently unavailable!"), (TextColor)NamedTextColor.RED));
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        return Collections.emptyList();
    }
}

