/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.custombiomecolors.nms;

import io.github.lumine1909.custombiomecolors.nms.BiomeAccessor;
import io.github.lumine1909.custombiomecolors.nms.ServerDataHandler;
import io.github.lumine1909.custombiomecolors.object.BiomeData;
import io.github.lumine1909.custombiomecolors.object.BiomeKey;
import io.github.lumine1909.custombiomecolors.object.ColorData;
import io.github.lumine1909.custombiomecolors.object.ColorType;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import org.jetbrains.annotations.NotNull;

public class BiomeAccessor_1_21
extends BiomeAccessor<Biome, Holder<Biome>, ResourceKey<Biome>> {
    public BiomeAccessor_1_21(Holder<Biome> biomeHolder) {
        this(biomeHolder, BiomeAccessor_1_21.fetchNmsBiomeData(biomeHolder));
    }

    public BiomeAccessor_1_21(Holder<Biome> biomeHolder, BiomeData cachedData) {
        super(biomeHolder, (Biome)biomeHolder.value(), cachedData);
    }

    private static BiomeData fetchNmsBiomeData(Holder<Biome> nmsBiome) {
        BiomeSpecialEffects specialEffects = ((Biome)nmsBiome.value()).getSpecialEffects();
        ColorData colorData = new ColorData.Builder().set(ColorType.GRASS, specialEffects.getGrassColorOverride().orElse(null)).set(ColorType.FOLIAGE, specialEffects.getFoliageColorOverride().orElse(null)).set(ColorType.WATER, specialEffects.getWaterColor()).set(ColorType.WATER_FOG, specialEffects.getWaterFogColor()).set(ColorType.SKY, specialEffects.getSkyColor()).set(ColorType.FOG, specialEffects.getFogColor()).build();
        BiomeKey biomeKey = BiomeKey.fromString(nmsBiome.getRegisteredName());
        return new BiomeData(biomeKey, biomeKey, colorData);
    }

    @Override
    public BiomeAccessor<Biome, Holder<@NotNull Biome>, ResourceKey<@NotNull Biome>> cloneWithDifferentColor(ServerDataHandler<Biome, Holder<@NotNull Biome>, ResourceKey<@NotNull Biome>> serverDataHandler, BiomeKey newBiomeKey, ColorData colorData) {
        BiomeData data = this.getBiomeData();
        return serverDataHandler.createCustomBiome(new BiomeData(newBiomeKey, data.baseBiomeKey(), colorData));
    }

    @Override
    public float getTemperature() {
        return ((Biome)this.biomeBase).climateSettings.temperature();
    }

    @Override
    public float getHumidity() {
        return ((Biome)this.biomeBase).climateSettings.downfall();
    }
}

