/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.custombiomecolors.nms;

import io.github.lumine1909.custombiomecolors.nms.BiomeAccessor;
import io.github.lumine1909.custombiomecolors.nms.ServerDataHandler;
import io.github.lumine1909.custombiomecolors.object.BiomeData;
import io.github.lumine1909.custombiomecolors.object.BiomeKey;
import io.github.lumine1909.custombiomecolors.object.ColorData;
import io.github.lumine1909.custombiomecolors.object.ColorType;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.attribute.EnvironmentAttributeMap;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import org.jetbrains.annotations.NotNull;

public class BiomeAccessor_1_21_11
extends BiomeAccessor<Biome, Holder<Biome>, ResourceKey<Biome>> {
    public BiomeAccessor_1_21_11(Holder<@NotNull Biome> biomeHolder) {
        this(biomeHolder, BiomeAccessor_1_21_11.fetchNmsBiomeData(biomeHolder));
    }

    public BiomeAccessor_1_21_11(Holder<@NotNull Biome> biomeHolder, BiomeData cachedData) {
        super(biomeHolder, (Biome)biomeHolder.value(), cachedData);
    }

    private static BiomeData fetchNmsBiomeData(Holder<@NotNull Biome> nmsBiome) {
        BiomeSpecialEffects specialEffects = ((Biome)nmsBiome.value()).getSpecialEffects();
        EnvironmentAttributeMap attributes = ((Biome)nmsBiome.value()).getAttributes();
        ColorData colorData = new ColorData.Builder().set(ColorType.GRASS, specialEffects.grassColorOverride().orElse(null)).set(ColorType.FOLIAGE, specialEffects.foliageColorOverride().orElse(null)).set(ColorType.DRY_FOLIAGE, specialEffects.dryFoliageColorOverride().orElse(null)).set(ColorType.WATER, specialEffects.waterColor()).set(ColorType.WATER_FOG, BiomeAccessor_1_21_11.getData(attributes.get(EnvironmentAttributes.WATER_FOG_COLOR))).set(ColorType.SKY, BiomeAccessor_1_21_11.getData(attributes.get(EnvironmentAttributes.SKY_COLOR))).set(ColorType.FOG, BiomeAccessor_1_21_11.getData(attributes.get(EnvironmentAttributes.FOG_COLOR))).set(ColorType.SUNRISE_SUNSET, BiomeAccessor_1_21_11.getData(attributes.get(EnvironmentAttributes.SUNRISE_SUNSET_COLOR))).set(ColorType.CLOUD, BiomeAccessor_1_21_11.getData(attributes.get(EnvironmentAttributes.CLOUD_COLOR))).set(ColorType.SKY_LIGHT, BiomeAccessor_1_21_11.getData(attributes.get(EnvironmentAttributes.SKY_LIGHT_COLOR))).build();
        BiomeKey biomeKey = BiomeKey.fromString(nmsBiome.getRegisteredName());
        return new BiomeData(biomeKey, biomeKey, colorData);
    }

    private static Integer getData(// Could not load outer class - annotation placement on inner may be incorrect
    EnvironmentAttributeMap.Entry<@NotNull Integer, ?> entry) {
        return entry == null ? null : (Integer)entry.applyModifier((Object)0);
    }

    @Override
    public BiomeAccessor<Biome, Holder<@NotNull Biome>, ResourceKey<@NotNull Biome>> cloneWithDifferentColor(ServerDataHandler<Biome, Holder<@NotNull Biome>, ResourceKey<@NotNull Biome>> serverDataHandler, BiomeKey newBiomeKey, ColorData colorData) {
        BiomeData data = this.getBiomeData();
        return serverDataHandler.createCustomBiome(new BiomeData(newBiomeKey, data.baseBiomeKey(), colorData));
    }

    @Override
    public float getTemperature() {
        return ((Biome)this.biomeBase).climateSettings.temperature();
    }

    @Override
    public float getHumidity() {
        return ((Biome)this.biomeBase).climateSettings.downfall();
    }
}

