/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.custombiomecolors.nms;

import io.github.lumine1909.custombiomecolors.nms.PacketHandler;
import io.github.lumine1909.custombiomecolors.util.Reflection;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.BitStorage;
import net.minecraft.util.CrudeIncrementalIntIdentityHashBiMap;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.HashMapPalette;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.LinearPalette;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.SingleValuePalette;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PacketHandler_1_21_11
implements PacketHandler {
    private static final MappedRegistry<@NotNull Biome> REGISTRY = (MappedRegistry)MinecraftServer.getServer().registryAccess().lookup(Registries.BIOME).orElseThrow();
    private static final int PLAINS_ID = REGISTRY.getId((Object)((Biome)((Holder.Reference)REGISTRY.get(Identifier.fromNamespaceAndPath((String)"minecraft", (String)"plains")).orElseThrow()).value()));
    private static final PalettedContainerFactory CONTAINER_FACTORY = PalettedContainerFactory.create((RegistryAccess)MinecraftServer.getServer().registryAccess());

    @Override
    public void inject() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.injectPlayer(player);
        }
    }

    @Override
    public void uninject() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.uninjectPlayer(player);
        }
    }

    @Override
    public void injectPlayer(Player player) {
        ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        Channel channel = serverPlayer.connection.connection.channel;
        if (channel.pipeline().get("cbc-handler") != null) {
            channel.pipeline().remove("cbc-handler");
        }
        channel.pipeline().addBefore("packet_handler", "cbc-handler", (ChannelHandler)new PacketInterceptor(player));
    }

    @Override
    public void uninjectPlayer(Player player) {
        ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        Channel channel = serverPlayer.connection.connection.channel;
        if (channel.pipeline().get("cbc-handler") != null) {
            channel.pipeline().remove("cbc-handler");
        }
    }

    private static final class PacketInterceptor
    extends ChannelDuplexHandler {
        private final ServerPlayer player;
        private final long joinTime;
        private long warnTime = 0L;

        public PacketInterceptor(Player player) {
            this.player = ((CraftPlayer)player).getHandle();
            this.joinTime = System.currentTimeMillis();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (msg instanceof ClientboundChunksBiomesPacket) {
                List chunkBiomeData;
                ClientboundChunksBiomesPacket clientboundChunksBiomesPacket = (ClientboundChunksBiomesPacket)msg;
                try {
                    List list;
                    chunkBiomeData = list = clientboundChunksBiomesPacket.chunkBiomeData();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                ServerLevel level = this.player.level();
                ArrayList dataList = new ArrayList(chunkBiomeData.size());
                chunkBiomeData.forEach(c -> {
                    FriendlyByteBuf writeBuf = new FriendlyByteBuf(Unpooled.buffer());
                    this.modifyBiomeData(writeBuf, c.getReadBuffer(), level.getSectionsCount());
                    ClientboundChunksBiomesPacket.ChunkBiomeData data = new ClientboundChunksBiomesPacket.ChunkBiomeData(c.pos(), ByteBufUtil.getBytes((ByteBuf)writeBuf));
                    dataList.add(data);
                });
                msg = new ClientboundChunksBiomesPacket(dataList);
            } else if (msg instanceof ClientboundLevelChunkWithLightPacket) {
                ClientboundLevelChunkWithLightPacket packet = (ClientboundLevelChunkWithLightPacket)msg;
                ServerLevel level = this.player.level();
                ClientboundLevelChunkPacketData data = packet.getChunkData();
                FriendlyByteBuf writeBuf = new FriendlyByteBuf(Unpooled.buffer());
                this.modifyChunkData(data.getReadBuffer(), writeBuf, level.getSectionsCount());
                Reflection.field$ClientboundLevelChunkPacketData$buffer.set(data, ByteBufUtil.getBytes((ByteBuf)writeBuf));
            }
            super.write(ctx, msg, promise);
        }

        private void modifyBiomeData(FriendlyByteBuf readBuf, FriendlyByteBuf writeBuf, int size) {
            for (int index = 0; index < size; ++index) {
                LevelChunkSection section = new LevelChunkSection(CONTAINER_FACTORY.createForBlockStates(), CONTAINER_FACTORY.createForBiomes());
                section.readBiomes(readBuf);
                this.writeBiomes(writeBuf, section);
            }
        }

        private void modifyChunkData(FriendlyByteBuf readBuf, FriendlyByteBuf writeBuf, int size) {
            for (int index = 0; index < size; ++index) {
                LevelChunkSection section = new LevelChunkSection(CONTAINER_FACTORY.createForBlockStates(), CONTAINER_FACTORY.createForBiomes());
                section.read(readBuf);
                writeBuf.writeShort((int)Reflection.field$LevelChunkSection$nonEmptyBlockCount.get(section).shortValue());
                section.states.write(writeBuf, null, index);
                this.writeBiomes(writeBuf, section);
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private void writeBiomes(FriendlyByteBuf buf, LevelChunkSection levelChunkSection) {
            @NotNull @NotNull PalettedContainer container = (PalettedContainer)levelChunkSection.getBiomes();
            BitStorage storage = (BitStorage)Reflection.field$PalettedContainer$Data$storage.getUnsafe(Reflection.field$PalettedContainer$data.get(container));
            Object containerData = Reflection.field$PalettedContainer$data.get(container);
            @NotNull @NotNull Palette palette = (Palette)Reflection.field$PalettedContainer$Data$palette.getUnsafe(containerData);
            buf.writeByte(storage.getBits());
            if (palette instanceof SingleValuePalette) {
                @NotNull @NotNull SingleValuePalette single = (SingleValuePalette)palette;
                buf.writeVarInt(this.getModifiedId((Holder<Biome>)((Holder)Reflection.field$SingleValuePalette$value.getUnsafe(single))));
            } else if (palette instanceof LinearPalette) {
                @NotNull @NotNull LinearPalette linear = (LinearPalette)palette;
                Object[] array = (Object[])Reflection.field$LinearPalette$values.getUnsafe(linear);
                buf.writeVarInt(linear.getSize());
                for (int i = 0; i < linear.getSize(); ++i) {
                    buf.writeVarInt(this.getModifiedId((Holder<Biome>)((Holder)array[i])));
                }
            } else if (palette instanceof HashMapPalette) {
                @NotNull @NotNull HashMapPalette hashMap = (HashMapPalette)palette;
                @NotNull @NotNull CrudeIncrementalIntIdentityHashBiMap map = (CrudeIncrementalIntIdentityHashBiMap)Reflection.field$HashMapPalette$values.getUnsafe(hashMap);
                buf.writeVarInt(hashMap.getSize());
                for (int i = 0; i < hashMap.getSize(); ++i) {
                    buf.writeVarInt(this.getModifiedId((Holder<Biome>)((Holder)map.byId(i))));
                }
            }
            buf.writeFixedSizeLongArray(storage.getRaw());
        }

        private int getModifiedId(@NotNull @NotNull Holder<@NotNull Biome> origin) {
            long createTime = PacketHandler.createTimeCache.getOrDefault(origin.getRegisteredName(), 0L);
            if (createTime > this.joinTime) {
                this.warn();
                return PLAINS_ID;
            }
            return REGISTRY.getId((Object)((Biome)origin.value()));
        }

        private void warn() {
            if (System.currentTimeMillis() - this.warnTime > 30000L) {
                this.warnTime = System.currentTimeMillis();
                this.player.getBukkitEntity().sendMessage((Component)Component.text((String)"[CustomBiomeColors] You are loading a chunk with un-synchronized biome, it will be default to plains, please re-join to get the real color!", (TextColor)NamedTextColor.RED));
            }
        }
    }
}

