/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.custombiomecolors.nms;

import io.github.lumine1909.custombiomecolors.nms.BiomeAccessor;
import io.github.lumine1909.custombiomecolors.nms.BiomeAccessor_1_20_5;
import io.github.lumine1909.custombiomecolors.nms.ServerDataHandler;
import io.github.lumine1909.custombiomecolors.object.BiomeData;
import io.github.lumine1909.custombiomecolors.object.BiomeKey;
import io.github.lumine1909.custombiomecolors.object.ColorData;
import io.github.lumine1909.custombiomecolors.object.ColorType;
import io.github.lumine1909.custombiomecolors.util.Reflection;
import java.util.IdentityHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.chunk.LevelChunk;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftWorld;

public class ServerDataHandler_1_20_5
implements ServerDataHandler<Biome, Holder<Biome>, ResourceKey<Biome>> {
    private final MappedRegistry<Biome> biomeRegistry = (MappedRegistry)MinecraftServer.getServer().registryAccess().registry(Registries.BIOME).orElseThrow();
    private final Holder.Reference<Biome> plains = (Holder.Reference)this.biomeRegistry.getHolder(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)new ResourceLocation("minecraft", "plains"))).orElseThrow();

    @Override
    public BiomeAccessor<Biome, Holder<Biome>, ResourceKey<Biome>> getBiomeFromKey(BiomeKey biomeKey) {
        BiomeAccessor biome = BiomeData.getBiome(biomeKey);
        if (biome != null) {
            return biome;
        }
        return new BiomeAccessor_1_20_5((Holder<Biome>)((Holder)this.biomeRegistry.getHolder(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)new ResourceLocation(biomeKey.key(), biomeKey.value()))).orElseThrow()));
    }

    @Override
    public BiomeAccessor<Biome, Holder<Biome>, ResourceKey<Biome>> wrapToAccessor(Holder<Biome> biomeBase) {
        BiomeAccessor biome = BiomeData.getBiomeFromHolder(biomeBase);
        if (biome != null) {
            return biome;
        }
        return new BiomeAccessor_1_20_5(biomeBase);
    }

    @Override
    public boolean hasBiome(BiomeKey biomeKey) {
        return this.biomeRegistry.getHolder(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)new ResourceLocation(biomeKey.key(), biomeKey.value()))).isPresent();
    }

    @Override
    public BiomeAccessor<Biome, Holder<Biome>, ResourceKey<Biome>> createCustomBiome(BiomeData biomeData) {
        Holder holder = (Holder)this.biomeRegistry.getHolder(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)new ResourceLocation(biomeData.baseBiomeKey().key(), biomeData.baseBiomeKey().value()))).orElse(this.plains);
        Biome biome = (Biome)holder.value();
        ColorData colorData = biomeData.colorData();
        BiomeKey biomeKey = biomeData.biomeKey();
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)new ResourceLocation(biomeKey.key(), biomeKey.value()));
        Biome.BiomeBuilder biomeBuilder = new Biome.BiomeBuilder().generationSettings(biome.getGenerationSettings()).mobSpawnSettings(biome.getMobSettings()).hasPrecipitation(biome.hasPrecipitation()).temperature(biome.climateSettings.temperature()).downfall(biome.climateSettings.downfall()).temperatureAdjustment(biome.climateSettings.temperatureModifier());
        BiomeSpecialEffects.Builder builder = new BiomeSpecialEffects.Builder();
        builder.grassColorModifier(BiomeSpecialEffects.GrassColorModifier.NONE).waterColor(colorData.get(ColorType.WATER).intValue()).waterFogColor(colorData.get(ColorType.WATER_FOG).intValue()).skyColor(colorData.get(ColorType.SKY).intValue()).fogColor(colorData.get(ColorType.FOG).intValue());
        if (colorData.has(ColorType.GRASS)) {
            builder.grassColorOverride(colorData.get(ColorType.GRASS).intValue());
        }
        if (colorData.has(ColorType.FOLIAGE)) {
            builder.foliageColorOverride(colorData.get(ColorType.FOLIAGE).intValue());
        }
        biomeBuilder.specialEffects(builder.build());
        Biome customBiome = biomeBuilder.build();
        return new BiomeAccessor_1_20_5(this.registerBiome((Holder<Biome>)holder, customBiome, (ResourceKey<Biome>)resourceKey), biomeData);
    }

    @Override
    public void setBiomeAt(Location location, BiomeAccessor<Biome, Holder<Biome>, ResourceKey<Biome>> biomeAccessor) {
        BlockPos blockPosition = new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ServerLevel nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        LevelChunk chunk = nmsWorld.getChunkAt(blockPosition);
        chunk.setBiome(location.getBlockX() >> 2, location.getBlockY() >> 2, location.getBlockZ() >> 2, biomeAccessor.getBiomeHolder());
    }

    @Override
    public Holder<Biome> getBiomeAt(Location location) {
        BlockPos blockPosition = new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ServerLevel nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        LevelChunk chunk = nmsWorld.getChunkAt(blockPosition);
        return chunk.getNoiseBiome(location.getBlockX() >> 2, location.getBlockY() >> 2, location.getBlockZ() >> 2);
    }

    @Override
    public Holder<Biome> registerBiome(Holder<Biome> original, Biome biome, ResourceKey<Biome> resourceKey) {
        try {
            Reflection.field$MappedRegistry$frozen.set(this.biomeRegistry, false);
            Reflection.field$MappedRegistry$unregisteredIntrusiveHolders.set(this.biomeRegistry, new IdentityHashMap());
            this.biomeRegistry.createIntrusiveHolder((Object)biome);
            Holder.Reference holder = this.biomeRegistry.register(resourceKey, (Object)biome, RegistrationInfo.BUILT_IN);
            Reflection.method$Holder$bindTags.invoke(holder, original.tags().toList());
            Reflection.field$MappedRegistry$unregisteredIntrusiveHolders.set(this.biomeRegistry, null);
            Reflection.field$MappedRegistry$frozen.set(this.biomeRegistry, true);
            return holder;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

