/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.custombiomecolors.nms;

import io.github.lumine1909.custombiomecolors.nms.BiomeAccessor;
import io.github.lumine1909.custombiomecolors.nms.BiomeAccessor_1_21_11;
import io.github.lumine1909.custombiomecolors.nms.ServerDataHandler;
import io.github.lumine1909.custombiomecolors.object.BiomeData;
import io.github.lumine1909.custombiomecolors.object.BiomeKey;
import io.github.lumine1909.custombiomecolors.object.ColorData;
import io.github.lumine1909.custombiomecolors.object.ColorType;
import io.github.lumine1909.custombiomecolors.util.Reflection;
import java.util.IdentityHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.attribute.EnvironmentAttributeMap;
import net.minecraft.world.attribute.EnvironmentAttributeSystem;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftWorld;
import org.jetbrains.annotations.NotNull;

public class ServerDataHandler_1_21_11
implements ServerDataHandler<Biome, Holder<Biome>, ResourceKey<Biome>> {
    private final MappedRegistry<@NotNull Biome> biomeRegistry = (MappedRegistry)MinecraftServer.getServer().registryAccess().lookup(Registries.BIOME).orElseThrow();
    private final // Could not load outer class - annotation placement on inner may be incorrect
    Holder.Reference<@NotNull Biome> plains = (Holder.Reference)this.biomeRegistry.get(ResourceKey.create((ResourceKey)Registries.BIOME, (Identifier)Identifier.fromNamespaceAndPath((String)"minecraft", (String)"plains"))).orElseThrow();

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public BiomeAccessor<Biome, Holder<@NotNull Biome>, ResourceKey<@NotNull Biome>> getBiomeFromKey(BiomeKey biomeKey) {
        @NotNull @NotNull BiomeAccessor biome = BiomeData.getBiome(biomeKey);
        if (biome != null) {
            return biome;
        }
        return new BiomeAccessor_1_21_11((Holder<Biome>)((Holder)this.biomeRegistry.get(ResourceKey.create((ResourceKey)Registries.BIOME, (Identifier)Identifier.fromNamespaceAndPath((String)biomeKey.key(), (String)biomeKey.value()))).orElseThrow()));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public BiomeAccessor<Biome, Holder<@NotNull Biome>, ResourceKey<@NotNull Biome>> wrapToAccessor(Holder<@NotNull Biome> biomeBase) {
        @NotNull @NotNull BiomeAccessor biome = BiomeData.getBiomeFromHolder(biomeBase);
        if (biome != null) {
            return biome;
        }
        return new BiomeAccessor_1_21_11(biomeBase);
    }

    @Override
    public boolean hasBiome(BiomeKey biomeKey) {
        return this.biomeRegistry.get(ResourceKey.create((ResourceKey)Registries.BIOME, (Identifier)Identifier.fromNamespaceAndPath((String)biomeKey.key(), (String)biomeKey.value()))).isPresent();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public BiomeAccessor<Biome, Holder<@NotNull Biome>, ResourceKey<@NotNull Biome>> createCustomBiome(BiomeData biomeData) {
        @NotNull Holder holder = (Holder)this.biomeRegistry.get(ResourceKey.create((ResourceKey)Registries.BIOME, (Identifier)Identifier.fromNamespaceAndPath((String)biomeData.baseBiomeKey().key(), (String)biomeData.baseBiomeKey().value()))).orElse(this.plains);
        Biome biome = (Biome)holder.value();
        ColorData colorData = biomeData.colorData();
        BiomeKey biomeKey = biomeData.biomeKey();
        @NotNull ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.BIOME, (Identifier)Identifier.fromNamespaceAndPath((String)biomeKey.key(), (String)biomeKey.value()));
        Biome.BiomeBuilder biomeBuilder = new Biome.BiomeBuilder().generationSettings(biome.getGenerationSettings()).mobSpawnSettings(biome.getMobSettings()).hasPrecipitation(biome.hasPrecipitation()).temperature(biome.climateSettings.temperature()).downfall(biome.climateSettings.downfall()).temperatureAdjustment(biome.climateSettings.temperatureModifier());
        BiomeSpecialEffects.Builder builder = new BiomeSpecialEffects.Builder();
        builder.grassColorModifier(BiomeSpecialEffects.GrassColorModifier.NONE).waterColor(colorData.get(ColorType.WATER).intValue());
        if (colorData.has(ColorType.GRASS)) {
            builder.grassColorOverride(colorData.get(ColorType.GRASS).intValue());
        }
        if (colorData.has(ColorType.FOLIAGE)) {
            builder.foliageColorOverride(colorData.get(ColorType.FOLIAGE).intValue());
        }
        if (colorData.has(ColorType.DRY_FOLIAGE)) {
            builder.dryFoliageColorOverride(colorData.get(ColorType.DRY_FOLIAGE).intValue());
        }
        biomeBuilder.specialEffects(builder.build());
        EnvironmentAttributeMap.Builder attributesBuilder = EnvironmentAttributeMap.builder().putAll(biome.getAttributes());
        if (colorData.has(ColorType.WATER_FOG)) {
            attributesBuilder.set(EnvironmentAttributes.WATER_FOG_COLOR, (Object)colorData.get(ColorType.WATER_FOG));
        }
        if (colorData.has(ColorType.SKY)) {
            attributesBuilder.set(EnvironmentAttributes.SKY_COLOR, (Object)colorData.get(ColorType.SKY));
        }
        if (colorData.has(ColorType.FOG)) {
            attributesBuilder.set(EnvironmentAttributes.FOG_COLOR, (Object)colorData.get(ColorType.FOG));
        }
        if (colorData.has(ColorType.SUNRISE_SUNSET)) {
            attributesBuilder.set(EnvironmentAttributes.SUNRISE_SUNSET_COLOR, (Object)colorData.get(ColorType.SUNRISE_SUNSET));
        }
        if (colorData.has(ColorType.CLOUD)) {
            attributesBuilder.set(EnvironmentAttributes.CLOUD_COLOR, (Object)colorData.get(ColorType.CLOUD));
        }
        if (colorData.has(ColorType.SKY_LIGHT)) {
            attributesBuilder.set(EnvironmentAttributes.SKY_COLOR, (Object)colorData.get(ColorType.SKY_LIGHT));
        }
        biomeBuilder.putAttributes(attributesBuilder);
        Biome customBiome = biomeBuilder.build();
        return new BiomeAccessor_1_21_11(this.registerBiome((Holder<Biome>)holder, customBiome, (ResourceKey<Biome>)resourceKey), biomeData);
    }

    @Override
    public void setBiomeAt(Location location, BiomeAccessor<Biome, Holder<@NotNull Biome>, ResourceKey<@NotNull Biome>> biomeAccessor) {
        BlockPos blockPosition = new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ServerLevel nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        LevelChunk chunk = nmsWorld.getChunkAt(blockPosition);
        chunk.setBiome(location.getBlockX() >> 2, location.getBlockY() >> 2, location.getBlockZ() >> 2, biomeAccessor.getBiomeHolder());
    }

    @Override
    public Holder<@NotNull Biome> getBiomeAt(Location location) {
        BlockPos blockPosition = new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ServerLevel nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        LevelChunk chunk = nmsWorld.getChunkAt(blockPosition);
        return chunk.getNoiseBiome(location.getBlockX() >> 2, location.getBlockY() >> 2, location.getBlockZ() >> 2);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public Holder<@NotNull Biome> registerBiome(Holder<@NotNull Biome> original, Biome biome, ResourceKey<@NotNull Biome> resourceKey) {
        try {
            Reflection.field$MappedRegistry$frozen.set(this.biomeRegistry, false);
            Reflection.field$MappedRegistry$unregisteredIntrusiveHolders.set(this.biomeRegistry, new IdentityHashMap());
            this.biomeRegistry.createIntrusiveHolder((Object)biome);
            // Could not load outer class - annotation placement on inner may be incorrect
            @NotNull Holder.Reference holder = this.biomeRegistry.register(resourceKey, (Object)biome, RegistrationInfo.BUILT_IN);
            Reflection.method$Holder$bindTags.invoke(holder, original.tags().toList());
            Reflection.field$MappedRegistry$unregisteredIntrusiveHolders.set(this.biomeRegistry, null);
            Reflection.field$MappedRegistry$frozen.set(this.biomeRegistry, true);
            return holder;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ColorData getDimensionColor(Location location) {
        ServerLevel level = ((CraftWorld)location.getWorld()).getHandle();
        EnvironmentAttributeSystem attributes = level.environmentAttributes();
        Vec3 vec3 = new Vec3(location.x(), location.y(), location.z());
        return new ColorData.Builder().set(ColorType.SKY, (Integer)attributes.getValue(EnvironmentAttributes.SKY_COLOR, vec3)).set(ColorType.FOG, (Integer)attributes.getValue(EnvironmentAttributes.FOG_COLOR, vec3)).set(ColorType.WATER_FOG, (Integer)attributes.getValue(EnvironmentAttributes.WATER_FOG_COLOR, vec3)).set(ColorType.CLOUD, (Integer)attributes.getValue(EnvironmentAttributes.CLOUD_COLOR, vec3)).set(ColorType.SUNRISE_SUNSET, (Integer)attributes.getValue(EnvironmentAttributes.SUNRISE_SUNSET_COLOR, vec3)).set(ColorType.SKY_LIGHT, (Integer)attributes.getValue(EnvironmentAttributes.SKY_LIGHT_COLOR, vec3)).build();
    }
}

