/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.custombiomecolors.util;

import io.github.lumine1909.custombiomecolors.object.ColorType;
import io.github.lumine1909.custombiomecolors.util.BiomeColorUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class MessageUtil {
    public static Component getColorMessage(ColorType colorType, int color, float temperature, float downfall) {
        return colorType.isSpecial() ? MessageUtil.getColorMessageSpecial(colorType, color, temperature, downfall) : MessageUtil.getColorMessage(colorType, color, false);
    }

    private static Component getColorMessage(ColorType colorType, int color, boolean isDefault) {
        TextComponent colorMessage = Component.text((String)String.format("#%0" + colorType.maskSize() + "X", color &= colorType.mask()), (TextColor)TextColor.color((int)color));
        return isDefault ? colorMessage.append((Component)Component.text((String)" (Default)", (TextColor)NamedTextColor.GRAY)) : colorMessage;
    }

    private static Component getColorMessageSpecial(ColorType colorType, Integer color, float temperature, float downfall) {
        if (color != null) {
            return MessageUtil.getColorMessage(colorType, color, false);
        }
        int defaultColor = switch (colorType) {
            case ColorType.GRASS -> BiomeColorUtil.getGrassColor(temperature, downfall);
            case ColorType.FOLIAGE -> BiomeColorUtil.getFoliageColor(temperature, downfall);
            case ColorType.DRY_FOLIAGE -> BiomeColorUtil.getDryFoliageColor(temperature, downfall);
            default -> throw new IllegalArgumentException("Invalid color type");
        };
        return MessageUtil.getColorMessage(colorType, defaultColor, true);
    }
}

