/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.custombiomecolors.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker
implements Listener {
    private static final String GITHUB_REPO = "Lumine1909/CustomBiomeColors_Continue";
    private final String currentVersion;
    private final Component message;
    private final JavaPlugin plugin;
    public boolean needUpdate;

    public UpdateChecker(JavaPlugin plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
        this.message = Component.text((String)"[CustomBiomeColors] There is an update available! Download it from: ", (TextColor)NamedTextColor.GREEN).append(Component.text((String)"https://github.com/Lumine1909/CustomBiomeColors_Continue/releases/latest", (TextColor)NamedTextColor.GRAY).clickEvent(ClickEvent.openUrl((String)"https://github.com/Lumine1909/CustomBiomeColors_Continue/releases/latest")));
        this.checkUpdates();
    }

    private static String cleanVersion(String version) {
        int buildIndex;
        if (version.startsWith("v")) {
            version = version.substring(1);
        }
        return (buildIndex = version.indexOf("-build")) >= 0 ? version.substring(0, buildIndex) : version;
    }

    public void checkUpdates() {
        CompletableFuture.runAsync(() -> {
            try (HttpClient client = HttpClient.newHttpClient();){
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.github.com/repos/Lumine1909/CustomBiomeColors_Continue/releases/latest")).header("User-Agent", "Update-Checker").build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() != 200) {
                    this.plugin.getLogger().warning("Failed to check update");
                    return;
                }
                JsonObject json = JsonParser.parseString((String)response.body()).getAsJsonObject();
                String tag = json.get("tag_name").getAsString();
                String latestVersion = UpdateChecker.cleanVersion(tag);
                if (!latestVersion.equalsIgnoreCase(this.currentVersion)) {
                    this.plugin.getLogger().warning("A new version is available: " + latestVersion + " (current: " + this.plugin.getDescription().getVersion() + ")");
                    this.needUpdate = true;
                } else {
                    this.plugin.getLogger().info("You are using the latest version.");
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Update check failed: " + e.getMessage());
            }
        });
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        if (p.isOp() && this.needUpdate) {
            p.sendMessage(this.message);
        }
    }
}

