/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.reflexion.field;

import io.github.lumine1909.reflexion.UnsafeUtil;
import io.github.lumine1909.reflexion.field.BooleanField;
import io.github.lumine1909.reflexion.field.ByteField;
import io.github.lumine1909.reflexion.field.DoubleField;
import io.github.lumine1909.reflexion.field.FloatField;
import io.github.lumine1909.reflexion.field.IntField;
import io.github.lumine1909.reflexion.field.LongField;
import io.github.lumine1909.reflexion.field.ObjectField;
import io.github.lumine1909.reflexion.field.ShortField;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public abstract class UnsafeFieldHolder<T> {
    protected final long objectOffset;
    protected final Object staticBase;
    protected final long staticOffset;

    public UnsafeFieldHolder(Field javaField) {
        this.objectOffset = Modifier.isStatic(javaField.getModifiers()) ? -1L : UnsafeUtil.UNSAFE.objectFieldOffset(javaField);
        this.staticBase = Modifier.isStatic(javaField.getModifiers()) ? UnsafeUtil.UNSAFE.staticFieldBase(javaField) : null;
        this.staticOffset = Modifier.isStatic(javaField.getModifiers()) ? UnsafeUtil.UNSAFE.staticFieldOffset(javaField) : -1L;
    }

    public static UnsafeFieldHolder<?> createHolder(Field field) {
        Class<?> type = field.getType();
        if (type == Byte.TYPE) {
            return new ByteField(field);
        }
        if (type == Boolean.TYPE) {
            return new BooleanField(field);
        }
        if (type == Integer.TYPE) {
            return new IntField(field);
        }
        if (type == Short.TYPE) {
            return new ShortField(field);
        }
        if (type == Long.TYPE) {
            return new LongField(field);
        }
        if (type == Double.TYPE) {
            return new DoubleField(field);
        }
        if (type == Float.TYPE) {
            return new FloatField(field);
        }
        return new ObjectField(field);
    }

    public T get(Object obj) {
        if (this.objectOffset == -1L && obj == null) {
            throw new NullPointerException("Instance is null for non-static field");
        }
        return this.objectOffset == -1L ? this.getStatic() : this.getInstance(obj);
    }

    public void set(Object obj, T value) {
        if (this.objectOffset == -1L) {
            if (obj == null) {
                throw new NullPointerException("Instance is null for non-static field");
            }
            this.setStatic(value);
            return;
        }
        this.setInstance(obj, value);
    }

    protected abstract T getStatic();

    protected abstract void setStatic(T var1);

    protected abstract T getInstance(Object var1);

    protected abstract void setInstance(Object var1, T var2);
}

