/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.custombiomecolors;

import io.github.lumine1909.custombiomecolors.BiomeManager;
import io.github.lumine1909.custombiomecolors.command.GetBiomeColorsCommand;
import io.github.lumine1909.custombiomecolors.command.ReloadCommand;
import io.github.lumine1909.custombiomecolors.command.SetBiomeColorCommand;
import io.github.lumine1909.custombiomecolors.command.UnsupportedCommand;
import io.github.lumine1909.custombiomecolors.data.DataManager;
import io.github.lumine1909.custombiomecolors.integration.WorldEditHandler;
import io.github.lumine1909.custombiomecolors.listener.PlayerListener;
import io.github.lumine1909.custombiomecolors.nms.NmsServer;
import io.github.lumine1909.custombiomecolors.nms.NmsServer_1_20_5;
import io.github.lumine1909.custombiomecolors.nms.NmsServer_1_21;
import io.github.lumine1909.custombiomecolors.nms.NmsServer_1_21_3;
import io.github.lumine1909.custombiomecolors.nms.NmsServer_1_21_5;
import io.github.lumine1909.custombiomecolors.nms.PacketHandler;
import io.github.lumine1909.custombiomecolors.nms.PacketHandler_1_20_5;
import io.github.lumine1909.custombiomecolors.nms.PacketHandler_1_21;
import io.github.lumine1909.custombiomecolors.nms.PacketHandler_1_21_3;
import io.github.lumine1909.custombiomecolors.nms.PacketHandler_1_21_5;
import io.github.lumine1909.custombiomecolors.util.BStats;
import io.github.lumine1909.custombiomecolors.util.BiomeColorUtil;
import io.github.lumine1909.custombiomecolors.util.UpdateChecker;
import io.github.lumine1909.custombiomecolors.util.object.BiomeColorType;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class CustomBiomeColors
extends JavaPlugin {
    private static CustomBiomeColors instance;
    private NmsServer nmsServer;
    private BiomeManager biomeManager;
    private WorldEditHandler worldEditHandler;
    private DataManager dataManager;
    private PacketHandler packetHandler;
    private BStats bStats;

    public static CustomBiomeColors getInstance() {
        return instance;
    }

    public static int obtainVersion() {
        try {
            String[] versions = Bukkit.getMinecraftVersion().split("\\.");
            if (versions.length == 2) {
                return Integer.parseInt(versions[1]) * 100;
            }
            if (versions.length == 3) {
                return Integer.parseInt(versions[1]) * 100 + Integer.parseInt(versions[2]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public NmsServer getNmsServer() {
        return this.nmsServer;
    }

    public BiomeManager getBiomeManager() {
        return this.biomeManager;
    }

    public WorldEditHandler getWorldEditHandler() {
        return this.worldEditHandler;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public PacketHandler getPacketHandler() {
        return this.packetHandler;
    }

    public void onLoad() {
        instance = this;
        int version = CustomBiomeColors.obtainVersion();
        if (version >= 2105) {
            this.nmsServer = new NmsServer_1_21_5();
            this.packetHandler = new PacketHandler_1_21_5();
        } else if (version >= 2103) {
            this.nmsServer = new NmsServer_1_21_3();
            this.packetHandler = new PacketHandler_1_21_3();
        } else if (version >= 2100) {
            this.nmsServer = new NmsServer_1_21();
            this.packetHandler = new PacketHandler_1_21();
        } else if (version >= 2005) {
            this.nmsServer = new NmsServer_1_20_5();
            this.packetHandler = new PacketHandler_1_20_5();
        } else {
            throw new IllegalStateException("This plugin only support MC 1.20.5 - 1.21.7, for other versions, please contact author at https://github.com/Lumine1909/CustomBiomeColors_Continue/issues");
        }
        this.dataManager = new DataManager("data.json");
        this.dataManager.loadBiomes();
    }

    public void onEnable() {
        this.bStats = new BStats((Plugin)this, 26161);
        this.biomeManager = new BiomeManager();
        this.worldEditHandler = new WorldEditHandler();
        BiomeColorUtil.loadColorMaps();
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        this.registerCommands();
        this.getPacketHandler().inject();
        new UpdateChecker(this);
    }

    private void registerCommands() {
        new ReloadCommand();
        SetBiomeColorCommand.register(this.getCommand("/setgrasscolor"), "/setgrasscolor", BiomeColorType.GRASS);
        SetBiomeColorCommand.register(this.getCommand("/setfoliagecolor"), "/setfoliagecolor", BiomeColorType.FOLIAGE);
        SetBiomeColorCommand.register(this.getCommand("/setwatercolor"), "/setwatercolor", BiomeColorType.WATER);
        SetBiomeColorCommand.register(this.getCommand("/setwaterfogcolor"), "/setwaterfogcolor", BiomeColorType.WATER_FOG);
        SetBiomeColorCommand.register(this.getCommand("/setskycolor"), "/setskycolor", BiomeColorType.SKY);
        SetBiomeColorCommand.register(this.getCommand("/setfogcolor"), "/setfogcolor", BiomeColorType.FOG);
        if (CustomBiomeColors.obtainVersion() >= 2105) {
            Objects.requireNonNull(this.getCommand("/setdryfoliagecolor")).setExecutor((CommandExecutor)new SetBiomeColorCommand("/setdryfoliagecolor", BiomeColorType.DRY_FOLIAGE));
        } else {
            Objects.requireNonNull(this.getCommand("/setdryfoliagecolor")).setExecutor((CommandExecutor)new UnsupportedCommand("1.21.5"));
        }
        Objects.requireNonNull(this.getCommand("/getbiomecolors")).setExecutor((CommandExecutor)new GetBiomeColorsCommand());
    }

    public void callReload(CommandSender sender) {
        sender.sendMessage((Component)Component.text((String)"[CustomBiomeColors] Reload complete", (TextColor)NamedTextColor.GREEN));
    }

    public void onDisable() {
        this.bStats.shutdown();
        this.dataManager.saveOnClose();
        this.getPacketHandler().uninject();
    }
}

