/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.custombiomecolors.command;

import io.github.lumine1909.custombiomecolors.CustomBiomeColors;
import io.github.lumine1909.custombiomecolors.nms.NmsBiome;
import io.github.lumine1909.custombiomecolors.nms.NmsServer;
import io.github.lumine1909.custombiomecolors.util.MessageUtil;
import io.github.lumine1909.custombiomecolors.util.object.BiomeData;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class GetBiomeColorsCommand
implements CommandExecutor {
    private static final NmsServer nmsServer = CustomBiomeColors.getInstance().getNmsServer();

    public boolean onCommand(@NotNull CommandSender sender, Command cmd, @NotNull String label, String @NotNull [] args) {
        if (cmd.getName().equalsIgnoreCase("/getbiomecolors")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                NmsBiome biome = nmsServer.getWrappedBiomeHolder(nmsServer.getBiomeAt(player.getLocation()));
                BiomeData biomeData = biome.getBiomeData();
                player.sendMessage(Component.text((String)("Colors of the biome you are in (" + String.valueOf(biomeData.biomeKey()) + "): "), (TextColor)NamedTextColor.GREEN).decorate(TextDecoration.BOLD));
                player.sendMessage(Component.text((String)" - Grass: ", (TextColor)NamedTextColor.GRAY).append(MessageUtil.getColorMessageGrass(biomeData.colorData().grassColor(), biome.getTemperature(), biome.getHumidity()).decorate(TextDecoration.BOLD)));
                player.sendMessage(Component.text((String)" - Foliage: ", (TextColor)NamedTextColor.GRAY).append(MessageUtil.getColorMessageGrass(biomeData.colorData().foliageColor(), biome.getTemperature(), biome.getHumidity()).decorate(TextDecoration.BOLD)));
                player.sendMessage(Component.text((String)" - Dry Foliage: ", (TextColor)NamedTextColor.GRAY).append(MessageUtil.getColorMessageDryFoliage(biomeData.colorData().dryFoliageColor(), biome.getTemperature(), biome.getHumidity()).decorate(TextDecoration.BOLD)));
                player.sendMessage(Component.text((String)" - Water: ", (TextColor)NamedTextColor.GRAY).append(MessageUtil.getColorMessage(biomeData.colorData().waterColor()).decorate(TextDecoration.BOLD)));
                player.sendMessage(Component.text((String)" - Water Fog: ", (TextColor)NamedTextColor.GRAY).append(MessageUtil.getColorMessage(biomeData.colorData().waterFogColor()).decorate(TextDecoration.BOLD)));
                player.sendMessage(Component.text((String)" - Sky: ", (TextColor)NamedTextColor.GRAY).append(MessageUtil.getColorMessage(biomeData.colorData().skyColor()).decorate(TextDecoration.BOLD)));
                player.sendMessage(Component.text((String)" - Fog: ", (TextColor)NamedTextColor.GRAY).append(MessageUtil.getColorMessage(biomeData.colorData().fogColor()).decorate(TextDecoration.BOLD)));
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
        }
        return false;
    }
}

