/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.custombiomecolors.command;

import com.sk89q.worldedit.regions.Region;
import io.github.lumine1909.custombiomecolors.CustomBiomeColors;
import io.github.lumine1909.custombiomecolors.integration.WorldEditHandler;
import io.github.lumine1909.custombiomecolors.nms.NmsServer;
import io.github.lumine1909.custombiomecolors.util.object.BiomeColorType;
import io.github.lumine1909.custombiomecolors.util.object.BiomeKey;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetBiomeColorCommand
implements TabExecutor {
    private static final WorldEditHandler worldEditHandler = CustomBiomeColors.getInstance().getWorldEditHandler();
    private static final NmsServer nmsServer = CustomBiomeColors.getInstance().getNmsServer();
    private final String command;
    private final BiomeColorType colorType;

    public SetBiomeColorCommand(String command, BiomeColorType colorType) {
        this.command = command;
        this.colorType = colorType;
    }

    public static void register(@Nullable PluginCommand command, String subCommand, BiomeColorType type) {
        if (command == null) {
            throw new RuntimeException("Unable to register command, command is null");
        }
        SetBiomeColorCommand setBiomeColorCommand = new SetBiomeColorCommand(subCommand, type);
        command.setExecutor((CommandExecutor)setBiomeColorCommand);
        command.setTabCompleter((TabCompleter)setBiomeColorCommand);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String @NotNull [] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage((Component)Component.text((String)"[CustomBiomeColors] Only players can use this command!", (TextColor)NamedTextColor.RED));
            return true;
        }
        Player player = (Player)sender;
        if (!cmd.getName().equalsIgnoreCase(this.command)) {
            return true;
        }
        if (args.length > 0) {
            int color;
            Optional<Region> optionalRegion = worldEditHandler.getSelectedRegion(sender.getName());
            if (optionalRegion.isEmpty()) {
                sender.sendMessage((Component)Component.text((String)"[CustomBiomeColors] Make a region selection first!", (TextColor)NamedTextColor.RED));
                return true;
            }
            Region selectedRegion = optionalRegion.get();
            try {
                color = Integer.parseInt(args[0].replace("#", ""), 16);
            }
            catch (NumberFormatException e) {
                sender.sendMessage((Component)Component.text((String)"[CustomBiomeColors] Invalid color, please use a valid hex color code!", (TextColor)NamedTextColor.RED));
                return true;
            }
            long time = System.currentTimeMillis();
            Runnable runWhenDone = () -> sender.sendMessage((Component)Component.text((String)("[CustomBiomeColors] Biome color was changed for approximately " + selectedRegion.getVolume() + " blocks. (" + (float)(System.currentTimeMillis() - time) / 1000.0f + "s)"), (TextColor)NamedTextColor.GREEN));
            if (args.length > 1) {
                if (!args[1].contains(":")) {
                    sender.sendMessage((Component)Component.text((String)"[CustomBiomeColors] The biome name must contain a colon! ( : )", (TextColor)NamedTextColor.RED));
                    return true;
                }
                BiomeKey biomeKey = BiomeKey.fromString(args[1]);
                if (nmsServer.doesBiomeExist(biomeKey)) {
                    sender.sendMessage((Component)Component.text((String)"[CustomBiomeColors] There is already exists a biome with that name, please use another one!", (TextColor)NamedTextColor.RED));
                    return true;
                }
                CustomBiomeColors.getInstance().getBiomeManager().changeBiomeColor(player, selectedRegion, this.colorType, color, biomeKey, true, runWhenDone);
            } else {
                CustomBiomeColors.getInstance().getBiomeManager().changeBiomeColor(player, selectedRegion, this.colorType, color, runWhenDone);
            }
            sender.sendMessage((Component)Component.text((String)("[CustomBiomeColors] Changing the biome of " + optionalRegion.orElseThrow().getVolume() + " blocks..."), (TextColor)NamedTextColor.AQUA));
            if (optionalRegion.orElseThrow().getVolume() > 200000L) {
                sender.sendMessage((Component)Component.text((String)"[CustomBiomeColors] This might take a while.", (TextColor)NamedTextColor.AQUA));
            }
            return true;
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 1) {
            return List.of("#HEXCODE");
        }
        if (args.length == 2) {
            return List.of("biome:name");
        }
        return Collections.emptyList();
    }
}

