/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.custombiomecolors.data;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.lumine1909.custombiomecolors.CustomBiomeColors;
import io.github.lumine1909.custombiomecolors.util.object.BiomeData;
import io.github.lumine1909.custombiomecolors.util.object.BiomeKey;
import io.github.lumine1909.custombiomecolors.util.object.ColorData;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class DataConverter {
    private final Map<String, int[]> rawMap = new ConcurrentHashMap<String, int[]>();

    public DataConverter(File file) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Type typeToken = new TypeToken<Map<String, int[]>>(){}.getType();
        if (!file.exists()) {
            CustomBiomeColors.getInstance().getSLF4JLogger().warn("Data file {} does not exist, skipping conversion.", (Object)file.getAbsolutePath());
            return;
        }
        try (FileReader reader = new FileReader(file);){
            Map loaded = (Map)gson.fromJson((Reader)reader, typeToken);
            if (loaded != null) {
                this.rawMap.putAll(loaded);
            }
        }
        catch (IOException e) {
            CustomBiomeColors.getInstance().getSLF4JLogger().error("Failed to load data from {}", (Object)file.getAbsolutePath(), (Object)e);
        }
    }

    public Map<BiomeKey, BiomeData> convert() {
        ConcurrentHashMap<BiomeKey, BiomeData> biomeDataMap = new ConcurrentHashMap<BiomeKey, BiomeData>();
        BiomeKey fallbackPlains = BiomeKey.fromString("minecraft:plains");
        for (Map.Entry<String, int[]> entry : this.rawMap.entrySet()) {
            String keyStr = entry.getKey();
            int[] color = entry.getValue();
            if (color == null || color.length < 6) {
                CustomBiomeColors.getInstance().getSLF4JLogger().warn("Skipping invalid color data for biome {}", (Object)keyStr);
                continue;
            }
            BiomeKey biomeKey = BiomeKey.fromString(keyStr);
            ColorData colorData = new ColorData(color[5], color[2], color[3], color[4], color[1] != 0 ? Optional.of(color[1]) : Optional.empty(), Optional.empty(), color[0] != 0 ? Optional.of(color[0]) : Optional.empty());
            BiomeData biomeData = new BiomeData(biomeKey, fallbackPlains, colorData);
            biomeDataMap.put(biomeKey, biomeData);
        }
        return biomeDataMap;
    }
}

