/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.custombiomecolors.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.github.lumine1909.custombiomecolors.CustomBiomeColors;
import io.github.lumine1909.custombiomecolors.data.DataConverter;
import io.github.lumine1909.custombiomecolors.data.adapter.BiomeDataAdapter;
import io.github.lumine1909.custombiomecolors.data.adapter.BiomeKeyAdapter;
import io.github.lumine1909.custombiomecolors.nms.NmsBiome;
import io.github.lumine1909.custombiomecolors.util.object.BiomeData;
import io.github.lumine1909.custombiomecolors.util.object.BiomeKey;
import io.github.lumine1909.custombiomecolors.util.object.ColorData;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class DataManager {
    private final CustomBiomeColors plugin = CustomBiomeColors.getInstance();
    private final File file;
    private final ExecutorService saveExecutor = Executors.newSingleThreadExecutor();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(BiomeKey.class, (Object)new BiomeKeyAdapter()).registerTypeAdapter(BiomeData.class, (Object)new BiomeDataAdapter()).create();
    private Map<BiomeKey, BiomeData> biomeDataMap;

    public DataManager(String fileName) {
        this.file = new File(this.plugin.getDataFolder(), fileName);
        if (!this.file.exists()) {
            this.plugin.saveResource(fileName, false);
        }
        try (FileReader reader = new FileReader(this.file);){
            Type typeToken = new TypeToken<Map<BiomeKey, BiomeData>>(this){}.getType();
            this.biomeDataMap = (Map)this.gson.fromJson((Reader)reader, typeToken);
        }
        catch (Exception e) {
            this.plugin.getSLF4JLogger().warn("It seems you are using an legacy data format, start converting...");
            DataConverter converter = new DataConverter(this.file);
            this.biomeDataMap = converter.convert();
            this.scheduleSave();
        }
        if (this.biomeDataMap == null) {
            this.biomeDataMap = new HashMap<BiomeKey, BiomeData>();
        }
    }

    private void save0() throws IOException {
        String json = this.gson.toJson(this.biomeDataMap);
        Files.write(this.file.toPath(), json.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public void saveBiome(BiomeKey biomeKey, BiomeData biomeData) {
        this.biomeDataMap.put(biomeKey, biomeData);
        this.scheduleSave();
    }

    private Future<?> scheduleSave() {
        return this.saveExecutor.submit(() -> {
            try {
                this.save0();
            }
            catch (Exception e) {
                this.plugin.getSLF4JLogger().error("Failed to save data", (Throwable)e);
            }
        });
    }

    @NotNull
    public NmsBiome getBiomeByColorOrElse(boolean forceKey, ColorData colorData, Supplier<NmsBiome> orElse) {
        NmsBiome biome;
        if (forceKey || (biome = BiomeData.getBiome(colorData)) == null || !biome.getBiomeData().biomeKey().toString().startsWith("cbc:")) {
            biome = orElse.get();
            this.saveBiome(biome.getBiomeData().biomeKey(), biome.getBiomeData());
            this.plugin.getPacketHandler().updateCache(biome.getBiomeData().biomeKey().toString(), System.currentTimeMillis() + 1000L);
        }
        return biome;
    }

    public void loadBiomes() {
        for (Map.Entry<BiomeKey, BiomeData> entry : this.biomeDataMap.entrySet()) {
            this.plugin.getNmsServer().createCustomBiome(entry.getValue());
        }
    }

    public void saveOnClose() {
        Future<?> future = this.scheduleSave();
        this.saveExecutor.shutdown();
        try {
            future.get(30L, TimeUnit.SECONDS);
            if (!this.saveExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                this.plugin.getSLF4JLogger().warn("Data save executor did not shut down cleanly");
            }
        }
        catch (Exception e) {
            this.plugin.getSLF4JLogger().error("Failed during shutdown save process", (Throwable)e);
        }
    }
}

