/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.custombiomecolors.nms;

import io.github.lumine1909.custombiomecolors.nms.NmsServer;
import io.github.lumine1909.custombiomecolors.util.object.BiomeData;
import io.github.lumine1909.custombiomecolors.util.object.BiomeKey;
import io.github.lumine1909.custombiomecolors.util.object.ColorData;

public abstract class NmsBiome<Biome, Holder, ResourceKey> {
    protected final Holder biomeHolder;
    protected final Biome biomeBase;
    protected final BiomeData cachedData;

    public NmsBiome(Holder biomeHolder, Biome biome, BiomeData cachedData) {
        this.biomeHolder = biomeHolder;
        this.biomeBase = biome;
        this.cachedData = cachedData;
        BiomeData.updateBiome(cachedData.colorData(), this);
    }

    public Holder getBiomeHolder() {
        return this.biomeHolder;
    }

    public Biome getBiome() {
        return this.biomeBase;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NmsBiome that = (NmsBiome)o;
        return that.biomeHolder.equals(this.biomeHolder) && that.cachedData.equals(this.cachedData);
    }

    public BiomeData getBiomeData() {
        return this.cachedData;
    }

    public abstract float getTemperature();

    public abstract float getHumidity();

    public abstract NmsBiome<Biome, Holder, ResourceKey> cloneWithDifferentColor(NmsServer<Biome, Holder, ResourceKey> var1, BiomeKey var2, ColorData var3);
}

