/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.custombiomecolors.nms;

import io.github.lumine1909.custombiomecolors.nms.NmsBiome;
import io.github.lumine1909.custombiomecolors.nms.NmsServer;
import io.github.lumine1909.custombiomecolors.util.Reflection;
import io.github.lumine1909.custombiomecolors.util.object.BiomeData;
import io.github.lumine1909.custombiomecolors.util.object.BiomeKey;
import io.github.lumine1909.custombiomecolors.util.object.ColorData;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;

public class NmsBiome_1_21
extends NmsBiome<Biome, Holder<Biome>, ResourceKey<Biome>> {
    public NmsBiome_1_21(Holder<Biome> biomeHolder) {
        this(biomeHolder, NmsBiome_1_21.fetchNmsBiomeData(biomeHolder));
    }

    public NmsBiome_1_21(Holder<Biome> biomeHolder, BiomeData cachedData) {
        super(biomeHolder, (Biome)biomeHolder.value(), cachedData);
    }

    private static BiomeData fetchNmsBiomeData(Holder<Biome> nmsBiome) {
        BiomeSpecialEffects biomeFog = (BiomeSpecialEffects)Reflection.field$Biome$specialEffects.get(nmsBiome.value());
        assert (biomeFog != null);
        ColorData colorData = new ColorData.Mutable().grass(biomeFog.getGrassColorOverride()).foliage(biomeFog.getFoliageColorOverride()).water(biomeFog.getWaterColor()).waterFog(biomeFog.getWaterFogColor()).sky(biomeFog.getSkyColor()).fog(biomeFog.getFogColor()).build();
        BiomeKey biomeKey = BiomeKey.fromString(nmsBiome.getRegisteredName());
        return new BiomeData(biomeKey, biomeKey, colorData);
    }

    @Override
    public NmsBiome<Biome, Holder<Biome>, ResourceKey<Biome>> cloneWithDifferentColor(NmsServer<Biome, Holder<Biome>, ResourceKey<Biome>> nmsServer, BiomeKey newBiomeKey, ColorData colorData) {
        ResourceKey customBiomeKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)newBiomeKey.key(), (String)newBiomeKey.value()));
        Biome.BiomeBuilder customBiomeBuilder = new Biome.BiomeBuilder().generationSettings(((Biome)this.getBiome()).getGenerationSettings()).mobSpawnSettings(((Biome)this.getBiome()).getMobSettings()).hasPrecipitation(((Biome)this.getBiome()).hasPrecipitation()).temperature(((Biome)this.getBiome()).climateSettings.temperature()).downfall(((Biome)this.getBiome()).climateSettings.downfall()).temperatureAdjustment(((Biome)this.getBiome()).climateSettings.temperatureModifier());
        BiomeSpecialEffects.Builder customBiomeColors = new BiomeSpecialEffects.Builder();
        customBiomeColors.grassColorModifier(BiomeSpecialEffects.GrassColorModifier.NONE).waterColor(colorData.waterColor()).waterFogColor(colorData.waterFogColor()).skyColor(colorData.skyColor()).fogColor(colorData.fogColor());
        if (colorData.grassColor().isPresent()) {
            customBiomeColors.grassColorOverride(colorData.grassColor().get().intValue());
        }
        if (colorData.foliageColor().isPresent()) {
            customBiomeColors.foliageColorOverride(colorData.foliageColor().get().intValue());
        }
        customBiomeBuilder.specialEffects(customBiomeColors.build());
        Biome customBiome = customBiomeBuilder.build();
        Holder<Biome> holder = nmsServer.registerBiome((Holder<Biome>)((Holder)this.getBiomeHolder()), customBiome, (ResourceKey<Biome>)customBiomeKey);
        return new NmsBiome_1_21(holder, new BiomeData(newBiomeKey, this.cachedData.baseBiomeKey(), colorData));
    }

    @Override
    public float getTemperature() {
        return ((Biome)this.biomeBase).climateSettings.temperature();
    }

    @Override
    public float getHumidity() {
        return ((Biome)this.biomeBase).climateSettings.downfall();
    }
}

