/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.custombiomecolors.nms;

import io.github.lumine1909.custombiomecolors.nms.NmsBiome;
import io.github.lumine1909.custombiomecolors.nms.NmsBiome_1_21_3;
import io.github.lumine1909.custombiomecolors.nms.NmsServer;
import io.github.lumine1909.custombiomecolors.util.Reflection;
import io.github.lumine1909.custombiomecolors.util.object.BiomeData;
import io.github.lumine1909.custombiomecolors.util.object.BiomeKey;
import io.github.lumine1909.custombiomecolors.util.object.ColorData;
import java.util.IdentityHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.chunk.LevelChunk;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftWorld;

public class NmsServer_1_21_3
implements NmsServer<Biome, Holder<Biome>, ResourceKey<Biome>> {
    private final MappedRegistry<Biome> biomeRegistry = (MappedRegistry)MinecraftServer.getServer().registryAccess().lookup(Registries.BIOME).orElseThrow();
    private final Holder.Reference<Biome> plains = (Holder.Reference)this.biomeRegistry.get(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"plains"))).orElseThrow();

    @Override
    public NmsBiome<Biome, Holder<Biome>, ResourceKey<Biome>> getBiomeFromBiomeKey(BiomeKey biomeKey) {
        NmsBiome biome = BiomeData.getBiome(biomeKey);
        if (biome != null) {
            return biome;
        }
        return new NmsBiome_1_21_3((Holder<Biome>)((Holder)this.biomeRegistry.get(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)biomeKey.key(), (String)biomeKey.value()))).orElseThrow()));
    }

    @Override
    public NmsBiome<Biome, Holder<Biome>, ResourceKey<Biome>> getWrappedBiomeHolder(Holder<Biome> biomeBase) {
        NmsBiome biome = BiomeData.getBiomeFromHolder(biomeBase);
        if (biome != null) {
            return biome;
        }
        return new NmsBiome_1_21_3(biomeBase);
    }

    @Override
    public boolean doesBiomeExist(BiomeKey biomeKey) {
        return this.biomeRegistry.get(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)biomeKey.key(), (String)biomeKey.value()))).isPresent();
    }

    @Override
    public NmsBiome<Biome, Holder<Biome>, ResourceKey<Biome>> createCustomBiome(BiomeData biomeData) {
        Holder biomeHolder = (Holder)this.biomeRegistry.get(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)biomeData.baseBiomeKey().key(), (String)biomeData.baseBiomeKey().value()))).orElse(this.plains);
        Biome biomeBase = (Biome)biomeHolder.value();
        ColorData colorData = biomeData.colorData();
        BiomeKey biomeKey = biomeData.biomeKey();
        ResourceKey customBiomeKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)biomeKey.key(), (String)biomeKey.value()));
        Biome.BiomeBuilder customBiomeBuilder = new Biome.BiomeBuilder().generationSettings(biomeBase.getGenerationSettings()).mobSpawnSettings(biomeBase.getMobSettings()).hasPrecipitation(biomeBase.hasPrecipitation()).temperature(biomeBase.climateSettings.temperature()).downfall(biomeBase.climateSettings.downfall()).temperatureAdjustment(biomeBase.climateSettings.temperatureModifier());
        BiomeSpecialEffects.Builder customBiomeColors = new BiomeSpecialEffects.Builder();
        customBiomeColors.grassColorModifier(BiomeSpecialEffects.GrassColorModifier.NONE).waterColor(colorData.waterColor()).waterFogColor(colorData.waterFogColor()).skyColor(colorData.skyColor()).fogColor(colorData.fogColor());
        if (colorData.grassColor().isPresent()) {
            customBiomeColors.grassColorOverride(colorData.grassColor().get().intValue());
        }
        if (colorData.foliageColor().isPresent()) {
            customBiomeColors.foliageColorOverride(colorData.foliageColor().get().intValue());
        }
        customBiomeBuilder.specialEffects(customBiomeColors.build());
        Biome customBiome = customBiomeBuilder.build();
        return new NmsBiome_1_21_3(this.registerBiome((Holder<Biome>)biomeHolder, customBiome, (ResourceKey<Biome>)customBiomeKey), biomeData);
    }

    @Override
    public void setBiomeAt(Location location, NmsBiome<Biome, Holder<Biome>, ResourceKey<Biome>> nmsBiome) {
        BlockPos blockPosition = new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ServerLevel nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        LevelChunk chunk = nmsWorld.getChunkAt(blockPosition);
        chunk.setBiome(location.getBlockX() >> 2, location.getBlockY() >> 2, location.getBlockZ() >> 2, nmsBiome.getBiomeHolder());
    }

    @Override
    public Holder<Biome> getBiomeAt(Location location) {
        BlockPos blockPosition = new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ServerLevel nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        LevelChunk chunk = nmsWorld.getChunkAt(blockPosition);
        return chunk.getNoiseBiome(location.getBlockX() >> 2, location.getBlockY() >> 2, location.getBlockZ() >> 2);
    }

    @Override
    public Holder<Biome> registerBiome(Holder<Biome> original, Biome biome, ResourceKey<Biome> resourceKey) {
        try {
            Reflection.field$MappedRegistry$frozen.set(this.biomeRegistry, false);
            Reflection.field$MappedRegistry$unregisteredIntrusiveHolders.set(this.biomeRegistry, new IdentityHashMap());
            this.biomeRegistry.createIntrusiveHolder((Object)biome);
            Holder.Reference holder = this.biomeRegistry.register(resourceKey, (Object)biome, RegistrationInfo.BUILT_IN);
            Reflection.method$Holder$bindTags.invoke(holder, original.tags().toList());
            Reflection.field$MappedRegistry$unregisteredIntrusiveHolders.set(this.biomeRegistry, null);
            Reflection.field$MappedRegistry$frozen.set(this.biomeRegistry, true);
            return holder;
        }
        catch (Exception error) {
            error.printStackTrace();
            return null;
        }
    }

    @Override
    public String getBiomeString(NmsBiome<Biome, Holder<Biome>, ResourceKey<Biome>> nmsBiome) {
        ResourceLocation resourceLocation = this.biomeRegistry.getKey((Object)nmsBiome.getBiome());
        return resourceLocation == null ? "minecraft:plain" : resourceLocation.toString();
    }
}

